/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.organizations;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.organizations._OrganizationSummary;

public final class OrganizationSummary
extends _OrganizationSummary {
    private final String id;
    private final String name;

    private OrganizationSummary(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OrganizationSummary && this.equalTo((OrganizationSummary)another);
    }

    private boolean equalTo(OrganizationSummary another) {
        return this.id.equals(another.id) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "OrganizationSummary{id=" + this.id + ", name=" + this.name + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private String id;
        private String name;

        private Builder() {
        }

        public final Builder from(OrganizationSummary instance) {
            return this.from((_OrganizationSummary)instance);
        }

        final Builder from(_OrganizationSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public OrganizationSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OrganizationSummary(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build OrganizationSummary, some of required attributes are not set " + attributes;
        }
    }
}

