/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.spaces.Rule;
import org.cloudfoundry.operations.spaces._SecurityGroup;

public final class SecurityGroup
extends _SecurityGroup {
    private final String name;
    private final List<Rule> rules;

    private SecurityGroup(Builder builder) {
        this.name = builder.name;
        this.rules = SecurityGroup.createUnmodifiableList(true, builder.rules);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SecurityGroup && this.equalTo((SecurityGroup)another);
    }

    private boolean equalTo(SecurityGroup another) {
        return this.name.equals(another.name) && this.rules.equals(another.rules);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.rules.hashCode();
        return h;
    }

    public String toString() {
        return "SecurityGroup{name=" + this.name + ", rules=" + this.rules + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private List<Rule> rules = new ArrayList<Rule>();

        private Builder() {
        }

        public final Builder from(SecurityGroup instance) {
            return this.from((_SecurityGroup)instance);
        }

        final Builder from(_SecurityGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllRules(instance.getRules());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rule(Rule element) {
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder rule(Rule ... elements) {
            for (Rule element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        public final Builder rules(Iterable<? extends Rule> elements) {
            this.rules.clear();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends Rule> elements) {
            for (Rule rule : elements) {
                this.rules.add(Objects.requireNonNull(rule, "rules element"));
            }
            return this;
        }

        public SecurityGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SecurityGroup(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build SecurityGroup, some of required attributes are not set " + attributes;
        }
    }
}

