package org.cloudfoundry.operations;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations.advanced.Advanced;
import org.cloudfoundry.operations.applications.Applications;
import org.cloudfoundry.operations.buildpacks.Buildpacks;
import org.cloudfoundry.operations.domains.Domains;
import org.cloudfoundry.operations.organizationadmin.OrganizationAdmin;
import org.cloudfoundry.operations.organizations.Organizations;
import org.cloudfoundry.operations.routes.Routes;
import org.cloudfoundry.operations.serviceadmin.ServiceAdmin;
import org.cloudfoundry.operations.services.Services;
import org.cloudfoundry.operations.spaceadmin.SpaceAdmin;
import org.cloudfoundry.operations.spaces.Spaces;
import org.cloudfoundry.operations.stacks.Stacks;
import org.cloudfoundry.routing.RoutingClient;
import org.cloudfoundry.uaa.UaaClient;
import reactor.core.publisher.Mono;

/**
 * The default implementation of the {@link CloudFoundryOperations} interface
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DefaultCloudFoundryOperations"})
public final class DefaultCloudFoundryOperations
    extends org.cloudfoundry.operations._DefaultCloudFoundryOperations {
  private final Advanced advanced;
  private final Applications applications;
  private final Buildpacks buildpacks;
  private final Domains domains;
  private final OrganizationAdmin organizationAdmin;
  private final Organizations organizations;
  private final Routes routes;
  private final ServiceAdmin serviceAdmin;
  private final Services services;
  private final SpaceAdmin spaceAdmin;
  private final Spaces spaces;
  private final Stacks stacks;
  private final Duration cacheDuration;
  private final @Nullable CloudFoundryClient cloudFoundryClient;
  private final Mono<CloudFoundryClient> cloudFoundryClientPublisher;
  private final @Nullable DopplerClient dopplerClient;
  private final Mono<DopplerClient> dopplerClientPublisher;
  private final @Nullable String organization;
  private final Mono<String> organizationId;
  private final @Nullable RoutingClient routingClient;
  private final Mono<RoutingClient> routingClientPublisher;
  private final @Nullable String space;
  private final Mono<String> spaceId;
  private final @Nullable UaaClient uaaClient;
  private final Mono<UaaClient> uaaClientPublisher;
  private final Mono<String> username;

  private DefaultCloudFoundryOperations(DefaultCloudFoundryOperations.Builder builder) {
    this.cacheDuration = builder.cacheDuration;
    this.cloudFoundryClient = builder.cloudFoundryClient;
    this.dopplerClient = builder.dopplerClient;
    this.organization = builder.organization;
    this.routingClient = builder.routingClient;
    this.space = builder.space;
    this.uaaClient = builder.uaaClient;
    this.advanced = initShim.advanced();
    this.applications = initShim.applications();
    this.buildpacks = initShim.buildpacks();
    this.domains = initShim.domains();
    this.organizationAdmin = initShim.organizationAdmin();
    this.organizations = initShim.organizations();
    this.routes = initShim.routes();
    this.serviceAdmin = initShim.serviceAdmin();
    this.services = initShim.services();
    this.spaceAdmin = initShim.spaceAdmin();
    this.spaces = initShim.spaces();
    this.stacks = initShim.stacks();
    this.cloudFoundryClientPublisher = initShim.getCloudFoundryClientPublisher();
    this.dopplerClientPublisher = initShim.getDopplerClientPublisher();
    this.organizationId = initShim.getOrganizationId();
    this.routingClientPublisher = initShim.getRoutingClientPublisher();
    this.spaceId = initShim.getSpaceId();
    this.uaaClientPublisher = initShim.getUaaClientPublisher();
    this.username = initShim.getUsername();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private Advanced advanced;
    private int advancedBuildStage;

    Advanced advanced() {
      if (advancedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (advancedBuildStage == STAGE_UNINITIALIZED) {
        advancedBuildStage = STAGE_INITIALIZING;
        this.advanced = Objects.requireNonNull(DefaultCloudFoundryOperations.super.advanced(), "advanced");
        advancedBuildStage = STAGE_INITIALIZED;
      }
      return this.advanced;
    }
    private Applications applications;
    private int applicationsBuildStage;

    Applications applications() {
      if (applicationsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationsBuildStage == STAGE_UNINITIALIZED) {
        applicationsBuildStage = STAGE_INITIALIZING;
        this.applications = Objects.requireNonNull(DefaultCloudFoundryOperations.super.applications(), "applications");
        applicationsBuildStage = STAGE_INITIALIZED;
      }
      return this.applications;
    }
    private Buildpacks buildpacks;
    private int buildpacksBuildStage;

    Buildpacks buildpacks() {
      if (buildpacksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buildpacksBuildStage == STAGE_UNINITIALIZED) {
        buildpacksBuildStage = STAGE_INITIALIZING;
        this.buildpacks = Objects.requireNonNull(DefaultCloudFoundryOperations.super.buildpacks(), "buildpacks");
        buildpacksBuildStage = STAGE_INITIALIZED;
      }
      return this.buildpacks;
    }
    private Domains domains;
    private int domainsBuildStage;

    Domains domains() {
      if (domainsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (domainsBuildStage == STAGE_UNINITIALIZED) {
        domainsBuildStage = STAGE_INITIALIZING;
        this.domains = Objects.requireNonNull(DefaultCloudFoundryOperations.super.domains(), "domains");
        domainsBuildStage = STAGE_INITIALIZED;
      }
      return this.domains;
    }
    private OrganizationAdmin organizationAdmin;
    private int organizationAdminBuildStage;

    OrganizationAdmin organizationAdmin() {
      if (organizationAdminBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationAdminBuildStage == STAGE_UNINITIALIZED) {
        organizationAdminBuildStage = STAGE_INITIALIZING;
        this.organizationAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.organizationAdmin(), "organizationAdmin");
        organizationAdminBuildStage = STAGE_INITIALIZED;
      }
      return this.organizationAdmin;
    }
    private Organizations organizations;
    private int organizationsBuildStage;

    Organizations organizations() {
      if (organizationsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationsBuildStage == STAGE_UNINITIALIZED) {
        organizationsBuildStage = STAGE_INITIALIZING;
        this.organizations = Objects.requireNonNull(DefaultCloudFoundryOperations.super.organizations(), "organizations");
        organizationsBuildStage = STAGE_INITIALIZED;
      }
      return this.organizations;
    }
    private Routes routes;
    private int routesBuildStage;

    Routes routes() {
      if (routesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routesBuildStage == STAGE_UNINITIALIZED) {
        routesBuildStage = STAGE_INITIALIZING;
        this.routes = Objects.requireNonNull(DefaultCloudFoundryOperations.super.routes(), "routes");
        routesBuildStage = STAGE_INITIALIZED;
      }
      return this.routes;
    }
    private ServiceAdmin serviceAdmin;
    private int serviceAdminBuildStage;

    ServiceAdmin serviceAdmin() {
      if (serviceAdminBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceAdminBuildStage == STAGE_UNINITIALIZED) {
        serviceAdminBuildStage = STAGE_INITIALIZING;
        this.serviceAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.serviceAdmin(), "serviceAdmin");
        serviceAdminBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceAdmin;
    }
    private Services services;
    private int servicesBuildStage;

    Services services() {
      if (servicesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicesBuildStage == STAGE_UNINITIALIZED) {
        servicesBuildStage = STAGE_INITIALIZING;
        this.services = Objects.requireNonNull(DefaultCloudFoundryOperations.super.services(), "services");
        servicesBuildStage = STAGE_INITIALIZED;
      }
      return this.services;
    }
    private SpaceAdmin spaceAdmin;
    private int spaceAdminBuildStage;

    SpaceAdmin spaceAdmin() {
      if (spaceAdminBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spaceAdminBuildStage == STAGE_UNINITIALIZED) {
        spaceAdminBuildStage = STAGE_INITIALIZING;
        this.spaceAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.spaceAdmin(), "spaceAdmin");
        spaceAdminBuildStage = STAGE_INITIALIZED;
      }
      return this.spaceAdmin;
    }
    private Spaces spaces;
    private int spacesBuildStage;

    Spaces spaces() {
      if (spacesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spacesBuildStage == STAGE_UNINITIALIZED) {
        spacesBuildStage = STAGE_INITIALIZING;
        this.spaces = Objects.requireNonNull(DefaultCloudFoundryOperations.super.spaces(), "spaces");
        spacesBuildStage = STAGE_INITIALIZED;
      }
      return this.spaces;
    }
    private Stacks stacks;
    private int stacksBuildStage;

    Stacks stacks() {
      if (stacksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stacksBuildStage == STAGE_UNINITIALIZED) {
        stacksBuildStage = STAGE_INITIALIZING;
        this.stacks = Objects.requireNonNull(DefaultCloudFoundryOperations.super.stacks(), "stacks");
        stacksBuildStage = STAGE_INITIALIZED;
      }
      return this.stacks;
    }
    private Mono<CloudFoundryClient> cloudFoundryClientPublisher;
    private int cloudFoundryClientPublisherBuildStage;

    Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
      if (cloudFoundryClientPublisherBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cloudFoundryClientPublisherBuildStage == STAGE_UNINITIALIZED) {
        cloudFoundryClientPublisherBuildStage = STAGE_INITIALIZING;
        this.cloudFoundryClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getCloudFoundryClientPublisher(), "cloudFoundryClientPublisher");
        cloudFoundryClientPublisherBuildStage = STAGE_INITIALIZED;
      }
      return this.cloudFoundryClientPublisher;
    }
    private Mono<DopplerClient> dopplerClientPublisher;
    private int dopplerClientPublisherBuildStage;

    Mono<DopplerClient> getDopplerClientPublisher() {
      if (dopplerClientPublisherBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dopplerClientPublisherBuildStage == STAGE_UNINITIALIZED) {
        dopplerClientPublisherBuildStage = STAGE_INITIALIZING;
        this.dopplerClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getDopplerClientPublisher(), "dopplerClientPublisher");
        dopplerClientPublisherBuildStage = STAGE_INITIALIZED;
      }
      return this.dopplerClientPublisher;
    }
    private Mono<String> organizationId;
    private int organizationIdBuildStage;

    Mono<String> getOrganizationId() {
      if (organizationIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationIdBuildStage == STAGE_UNINITIALIZED) {
        organizationIdBuildStage = STAGE_INITIALIZING;
        this.organizationId = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getOrganizationId(), "organizationId");
        organizationIdBuildStage = STAGE_INITIALIZED;
      }
      return this.organizationId;
    }
    private Mono<RoutingClient> routingClientPublisher;
    private int routingClientPublisherBuildStage;

    Mono<RoutingClient> getRoutingClientPublisher() {
      if (routingClientPublisherBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routingClientPublisherBuildStage == STAGE_UNINITIALIZED) {
        routingClientPublisherBuildStage = STAGE_INITIALIZING;
        this.routingClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getRoutingClientPublisher(), "routingClientPublisher");
        routingClientPublisherBuildStage = STAGE_INITIALIZED;
      }
      return this.routingClientPublisher;
    }
    private Mono<String> spaceId;
    private int spaceIdBuildStage;

    Mono<String> getSpaceId() {
      if (spaceIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spaceIdBuildStage == STAGE_UNINITIALIZED) {
        spaceIdBuildStage = STAGE_INITIALIZING;
        this.spaceId = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getSpaceId(), "spaceId");
        spaceIdBuildStage = STAGE_INITIALIZED;
      }
      return this.spaceId;
    }
    private Mono<UaaClient> uaaClientPublisher;
    private int uaaClientPublisherBuildStage;

    Mono<UaaClient> getUaaClientPublisher() {
      if (uaaClientPublisherBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (uaaClientPublisherBuildStage == STAGE_UNINITIALIZED) {
        uaaClientPublisherBuildStage = STAGE_INITIALIZING;
        this.uaaClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getUaaClientPublisher(), "uaaClientPublisher");
        uaaClientPublisherBuildStage = STAGE_INITIALIZED;
      }
      return this.uaaClientPublisher;
    }
    private Mono<String> username;
    private int usernameBuildStage;

    Mono<String> getUsername() {
      if (usernameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usernameBuildStage == STAGE_UNINITIALIZED) {
        usernameBuildStage = STAGE_INITIALIZING;
        this.username = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getUsername(), "username");
        usernameBuildStage = STAGE_INITIALIZED;
      }
      return this.username;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (advancedBuildStage == STAGE_INITIALIZING) attributes.add("advanced");
      if (applicationsBuildStage == STAGE_INITIALIZING) attributes.add("applications");
      if (buildpacksBuildStage == STAGE_INITIALIZING) attributes.add("buildpacks");
      if (domainsBuildStage == STAGE_INITIALIZING) attributes.add("domains");
      if (organizationAdminBuildStage == STAGE_INITIALIZING) attributes.add("organizationAdmin");
      if (organizationsBuildStage == STAGE_INITIALIZING) attributes.add("organizations");
      if (routesBuildStage == STAGE_INITIALIZING) attributes.add("routes");
      if (serviceAdminBuildStage == STAGE_INITIALIZING) attributes.add("serviceAdmin");
      if (servicesBuildStage == STAGE_INITIALIZING) attributes.add("services");
      if (spaceAdminBuildStage == STAGE_INITIALIZING) attributes.add("spaceAdmin");
      if (spacesBuildStage == STAGE_INITIALIZING) attributes.add("spaces");
      if (stacksBuildStage == STAGE_INITIALIZING) attributes.add("stacks");
      if (cloudFoundryClientPublisherBuildStage == STAGE_INITIALIZING) attributes.add("cloudFoundryClientPublisher");
      if (dopplerClientPublisherBuildStage == STAGE_INITIALIZING) attributes.add("dopplerClientPublisher");
      if (organizationIdBuildStage == STAGE_INITIALIZING) attributes.add("organizationId");
      if (routingClientPublisherBuildStage == STAGE_INITIALIZING) attributes.add("routingClientPublisher");
      if (spaceIdBuildStage == STAGE_INITIALIZING) attributes.add("spaceId");
      if (uaaClientPublisherBuildStage == STAGE_INITIALIZING) attributes.add("uaaClientPublisher");
      if (usernameBuildStage == STAGE_INITIALIZING) attributes.add("username");
      return "Cannot build DefaultCloudFoundryOperations, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code advanced} attribute
   */
  @Override
  public Advanced advanced() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.advanced()
        : this.advanced;
  }

  /**
   * @return The computed-at-construction value of the {@code applications} attribute
   */
  @Override
  public Applications applications() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applications()
        : this.applications;
  }

  /**
   * @return The computed-at-construction value of the {@code buildpacks} attribute
   */
  @Override
  public Buildpacks buildpacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.buildpacks()
        : this.buildpacks;
  }

  /**
   * @return The computed-at-construction value of the {@code domains} attribute
   */
  @Override
  public Domains domains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.domains()
        : this.domains;
  }

  /**
   * @return The computed-at-construction value of the {@code organizationAdmin} attribute
   */
  @Override
  public OrganizationAdmin organizationAdmin() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizationAdmin()
        : this.organizationAdmin;
  }

  /**
   * @return The computed-at-construction value of the {@code organizations} attribute
   */
  @Override
  public Organizations organizations() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizations()
        : this.organizations;
  }

  /**
   * @return The computed-at-construction value of the {@code routes} attribute
   */
  @Override
  public Routes routes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routes()
        : this.routes;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceAdmin} attribute
   */
  @Override
  public ServiceAdmin serviceAdmin() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceAdmin()
        : this.serviceAdmin;
  }

  /**
   * @return The computed-at-construction value of the {@code services} attribute
   */
  @Override
  public Services services() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.services()
        : this.services;
  }

  /**
   * @return The computed-at-construction value of the {@code spaceAdmin} attribute
   */
  @Override
  public SpaceAdmin spaceAdmin() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaceAdmin()
        : this.spaceAdmin;
  }

  /**
   * @return The computed-at-construction value of the {@code spaces} attribute
   */
  @Override
  public Spaces spaces() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaces()
        : this.spaces;
  }

  /**
   * @return The computed-at-construction value of the {@code stacks} attribute
   */
  @Override
  public Stacks stacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.stacks()
        : this.stacks;
  }

  /**
   * The duration that stable responses like the organization and space id should be cached
   */
  @Override
  public Optional<Duration> getCacheDuration() {
    return Optional.ofNullable(cacheDuration);
  }

  /**
   * The {@link CloudFoundryClient} to use for operations functionality
   */
  @Override
  public @Nullable CloudFoundryClient getCloudFoundryClient() {
    return cloudFoundryClient;
  }

  /**
   * @return The computed-at-construction value of the {@code cloudFoundryClientPublisher} attribute
   */
  @Override
  public Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCloudFoundryClientPublisher()
        : this.cloudFoundryClientPublisher;
  }

  /**
   * The {@link DopplerClient} to use for operations functionality
   */
  @Override
  public @Nullable DopplerClient getDopplerClient() {
    return dopplerClient;
  }

  /**
   * @return The computed-at-construction value of the {@code dopplerClientPublisher} attribute
   */
  @Override
  public Mono<DopplerClient> getDopplerClientPublisher() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDopplerClientPublisher()
        : this.dopplerClientPublisher;
  }

  /**
   * The organization to target
   */
  @Override
  public @Nullable String getOrganization() {
    return organization;
  }

  /**
   * @return The computed-at-construction value of the {@code organizationId} attribute
   */
  @Override
  public Mono<String> getOrganizationId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOrganizationId()
        : this.organizationId;
  }

  /**
   * The {@link RoutingClient} to use for operations functionality
   */
  @Override
  public @Nullable RoutingClient getRoutingClient() {
    return routingClient;
  }

  /**
   * @return The computed-at-construction value of the {@code routingClientPublisher} attribute
   */
  @Override
  public Mono<RoutingClient> getRoutingClientPublisher() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoutingClientPublisher()
        : this.routingClientPublisher;
  }

  /**
   * The space to target
   */
  @Override
  public @Nullable String getSpace() {
    return space;
  }

  /**
   * @return The computed-at-construction value of the {@code spaceId} attribute
   */
  @Override
  public Mono<String> getSpaceId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSpaceId()
        : this.spaceId;
  }

  /**
   * The {@link UaaClient} to use for operations functionality
   */
  @Override
  public @Nullable UaaClient getUaaClient() {
    return uaaClient;
  }

  /**
   * @return The computed-at-construction value of the {@code uaaClientPublisher} attribute
   */
  @Override
  public Mono<UaaClient> getUaaClientPublisher() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUaaClientPublisher()
        : this.uaaClientPublisher;
  }

  /**
   * @return The computed-at-construction value of the {@code username} attribute
   */
  @Override
  public Mono<String> getUsername() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUsername()
        : this.username;
  }

  /**
   * This instance is equal to all instances of {@code DefaultCloudFoundryOperations} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DefaultCloudFoundryOperations
        && equalTo((DefaultCloudFoundryOperations) another);
  }

  private boolean equalTo(DefaultCloudFoundryOperations another) {
    return advanced.equals(another.advanced)
        && applications.equals(another.applications)
        && buildpacks.equals(another.buildpacks)
        && domains.equals(another.domains)
        && organizationAdmin.equals(another.organizationAdmin)
        && organizations.equals(another.organizations)
        && routes.equals(another.routes)
        && serviceAdmin.equals(another.serviceAdmin)
        && services.equals(another.services)
        && spaceAdmin.equals(another.spaceAdmin)
        && spaces.equals(another.spaces)
        && stacks.equals(another.stacks)
        && Objects.equals(cacheDuration, another.cacheDuration)
        && Objects.equals(cloudFoundryClient, another.cloudFoundryClient)
        && cloudFoundryClientPublisher.equals(another.cloudFoundryClientPublisher)
        && Objects.equals(dopplerClient, another.dopplerClient)
        && dopplerClientPublisher.equals(another.dopplerClientPublisher)
        && Objects.equals(organization, another.organization)
        && organizationId.equals(another.organizationId)
        && Objects.equals(routingClient, another.routingClient)
        && routingClientPublisher.equals(another.routingClientPublisher)
        && Objects.equals(space, another.space)
        && spaceId.equals(another.spaceId)
        && Objects.equals(uaaClient, another.uaaClient)
        && uaaClientPublisher.equals(another.uaaClientPublisher)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code advanced}, {@code applications}, {@code buildpacks}, {@code domains}, {@code organizationAdmin}, {@code organizations}, {@code routes}, {@code serviceAdmin}, {@code services}, {@code spaceAdmin}, {@code spaces}, {@code stacks}, {@code cacheDuration}, {@code cloudFoundryClient}, {@code cloudFoundryClientPublisher}, {@code dopplerClient}, {@code dopplerClientPublisher}, {@code organization}, {@code organizationId}, {@code routingClient}, {@code routingClientPublisher}, {@code space}, {@code spaceId}, {@code uaaClient}, {@code uaaClientPublisher}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + advanced.hashCode();
    h += (h << 5) + applications.hashCode();
    h += (h << 5) + buildpacks.hashCode();
    h += (h << 5) + domains.hashCode();
    h += (h << 5) + organizationAdmin.hashCode();
    h += (h << 5) + organizations.hashCode();
    h += (h << 5) + routes.hashCode();
    h += (h << 5) + serviceAdmin.hashCode();
    h += (h << 5) + services.hashCode();
    h += (h << 5) + spaceAdmin.hashCode();
    h += (h << 5) + spaces.hashCode();
    h += (h << 5) + stacks.hashCode();
    h += (h << 5) + Objects.hashCode(cacheDuration);
    h += (h << 5) + Objects.hashCode(cloudFoundryClient);
    h += (h << 5) + cloudFoundryClientPublisher.hashCode();
    h += (h << 5) + Objects.hashCode(dopplerClient);
    h += (h << 5) + dopplerClientPublisher.hashCode();
    h += (h << 5) + Objects.hashCode(organization);
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(routingClient);
    h += (h << 5) + routingClientPublisher.hashCode();
    h += (h << 5) + Objects.hashCode(space);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + Objects.hashCode(uaaClient);
    h += (h << 5) + uaaClientPublisher.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultCloudFoundryOperations} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DefaultCloudFoundryOperations{");
    builder.append("advanced=").append(advanced);
    builder.append(", ");
    builder.append("applications=").append(applications);
    builder.append(", ");
    builder.append("buildpacks=").append(buildpacks);
    builder.append(", ");
    builder.append("domains=").append(domains);
    builder.append(", ");
    builder.append("organizationAdmin=").append(organizationAdmin);
    builder.append(", ");
    builder.append("organizations=").append(organizations);
    builder.append(", ");
    builder.append("routes=").append(routes);
    builder.append(", ");
    builder.append("serviceAdmin=").append(serviceAdmin);
    builder.append(", ");
    builder.append("services=").append(services);
    builder.append(", ");
    builder.append("spaceAdmin=").append(spaceAdmin);
    builder.append(", ");
    builder.append("spaces=").append(spaces);
    builder.append(", ");
    builder.append("stacks=").append(stacks);
    if (cacheDuration != null) {
      builder.append(", ");
      builder.append("cacheDuration=").append(cacheDuration);
    }
    if (cloudFoundryClient != null) {
      builder.append(", ");
      builder.append("cloudFoundryClient=").append(cloudFoundryClient);
    }
    builder.append(", ");
    builder.append("cloudFoundryClientPublisher=").append(cloudFoundryClientPublisher);
    if (dopplerClient != null) {
      builder.append(", ");
      builder.append("dopplerClient=").append(dopplerClient);
    }
    builder.append(", ");
    builder.append("dopplerClientPublisher=").append(dopplerClientPublisher);
    if (organization != null) {
      builder.append(", ");
      builder.append("organization=").append(organization);
    }
    builder.append(", ");
    builder.append("organizationId=").append(organizationId);
    if (routingClient != null) {
      builder.append(", ");
      builder.append("routingClient=").append(routingClient);
    }
    builder.append(", ");
    builder.append("routingClientPublisher=").append(routingClientPublisher);
    if (space != null) {
      builder.append(", ");
      builder.append("space=").append(space);
    }
    builder.append(", ");
    builder.append("spaceId=").append(spaceId);
    if (uaaClient != null) {
      builder.append(", ");
      builder.append("uaaClient=").append(uaaClient);
    }
    builder.append(", ");
    builder.append("uaaClientPublisher=").append(uaaClientPublisher);
    builder.append(", ");
    builder.append("username=").append(username);
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link DefaultCloudFoundryOperations DefaultCloudFoundryOperations}.
   * @return A new DefaultCloudFoundryOperations builder
   */
  public static DefaultCloudFoundryOperations.Builder builder() {
    return new DefaultCloudFoundryOperations.Builder();
  }

  /**
   * Builds instances of type {@link DefaultCloudFoundryOperations DefaultCloudFoundryOperations}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Duration cacheDuration;
    private CloudFoundryClient cloudFoundryClient;
    private DopplerClient dopplerClient;
    private String organization;
    private RoutingClient routingClient;
    private String space;
    private UaaClient uaaClient;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultCloudFoundryOperations} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultCloudFoundryOperations instance) {
      return from((_DefaultCloudFoundryOperations) instance);
    }

    /**
     * Copy abstract value type {@code _DefaultCloudFoundryOperations} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DefaultCloudFoundryOperations instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<Duration> cacheDurationOptional = instance.getCacheDuration();
      if (cacheDurationOptional.isPresent()) {
        cacheDuration(cacheDurationOptional);
      }
      CloudFoundryClient cloudFoundryClientValue = instance.getCloudFoundryClient();
      if (cloudFoundryClientValue != null) {
        cloudFoundryClient(cloudFoundryClientValue);
      }
      DopplerClient dopplerClientValue = instance.getDopplerClient();
      if (dopplerClientValue != null) {
        dopplerClient(dopplerClientValue);
      }
      String organizationValue = instance.getOrganization();
      if (organizationValue != null) {
        organization(organizationValue);
      }
      RoutingClient routingClientValue = instance.getRoutingClient();
      if (routingClientValue != null) {
        routingClient(routingClientValue);
      }
      String spaceValue = instance.getSpace();
      if (spaceValue != null) {
        space(spaceValue);
      }
      UaaClient uaaClientValue = instance.getUaaClient();
      if (uaaClientValue != null) {
        uaaClient(uaaClientValue);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultCloudFoundryOperations#getCacheDuration() cacheDuration} to cacheDuration.
     * @param cacheDuration The value for cacheDuration
     * @return {@code this} builder for chained invocation
     */
    public final Builder cacheDuration(Duration cacheDuration) {
      this.cacheDuration = Objects.requireNonNull(cacheDuration, "cacheDuration");
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultCloudFoundryOperations#getCacheDuration() cacheDuration} to cacheDuration.
     * @param cacheDuration The value for cacheDuration
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cacheDuration(Optional<? extends Duration> cacheDuration) {
      this.cacheDuration = cacheDuration.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getCloudFoundryClient() cloudFoundryClient} attribute.
     * @param cloudFoundryClient The value for cloudFoundryClient (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cloudFoundryClient(@Nullable CloudFoundryClient cloudFoundryClient) {
      this.cloudFoundryClient = cloudFoundryClient;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getDopplerClient() dopplerClient} attribute.
     * @param dopplerClient The value for dopplerClient (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dopplerClient(@Nullable DopplerClient dopplerClient) {
      this.dopplerClient = dopplerClient;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getOrganization() organization} attribute.
     * @param organization The value for organization (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(@Nullable String organization) {
      this.organization = organization;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getRoutingClient() routingClient} attribute.
     * @param routingClient The value for routingClient (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routingClient(@Nullable RoutingClient routingClient) {
      this.routingClient = routingClient;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getSpace() space} attribute.
     * @param space The value for space (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(@Nullable String space) {
      this.space = space;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getUaaClient() uaaClient} attribute.
     * @param uaaClient The value for uaaClient (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uaaClient(@Nullable UaaClient uaaClient) {
      this.uaaClient = uaaClient;
      return this;
    }

    /**
     * Builds a new {@link DefaultCloudFoundryOperations DefaultCloudFoundryOperations}.
     * @return An immutable instance of DefaultCloudFoundryOperations
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DefaultCloudFoundryOperations build() {
      return new DefaultCloudFoundryOperations(this);
    }
  }
}
