package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the list service keys operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListServiceKeysRequest"})
public final class ListServiceKeysRequest extends org.cloudfoundry.operations.services._ListServiceKeysRequest {
  private final String serviceInstanceName;

  private ListServiceKeysRequest(ListServiceKeysRequest.Builder builder) {
    this.serviceInstanceName = builder.serviceInstanceName;
  }

  /**
   * The name of the service instance for which the keys will be listed
   */
  @Override
  public String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceKeysRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceKeysRequest
        && equalTo((ListServiceKeysRequest) another);
  }

  private boolean equalTo(ListServiceKeysRequest another) {
    return serviceInstanceName.equals(another.serviceInstanceName);
  }

  /**
   * Computes a hash code from attributes: {@code serviceInstanceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceInstanceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceKeysRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceKeysRequest{"
        + "serviceInstanceName=" + serviceInstanceName
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceKeysRequest ListServiceKeysRequest}.
   * @return A new ListServiceKeysRequest builder
   */
  public static ListServiceKeysRequest.Builder builder() {
    return new ListServiceKeysRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceKeysRequest ListServiceKeysRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 0x1L;
    private long initBits = 0x1L;

    private String serviceInstanceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceKeysRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceKeysRequest instance) {
      return from((_ListServiceKeysRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListServiceKeysRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListServiceKeysRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceInstanceName(instance.getServiceInstanceName());
      return this;
    }

    /**
     * Initializes the value for the {@link _ListServiceKeysRequest#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String serviceInstanceName) {
      this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ListServiceKeysRequest ListServiceKeysRequest}.
     * @return An immutable instance of ListServiceKeysRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceKeysRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListServiceKeysRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_NAME) != 0) attributes.add("serviceInstanceName");
      return "Cannot build ListServiceKeysRequest, some of required attributes are not set " + attributes;
    }
  }
}
