package org.cloudfoundry.operations.stacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the get stack operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetStackRequest"})
public final class GetStackRequest extends org.cloudfoundry.operations.stacks._GetStackRequest {
  private final String name;

  private GetStackRequest(GetStackRequest.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The name of the stack
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code GetStackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetStackRequest
        && equalTo((GetStackRequest) another);
  }

  private boolean equalTo(GetStackRequest another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetStackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetStackRequest{"
        + "name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link GetStackRequest GetStackRequest}.
   * @return A new GetStackRequest builder
   */
  public static GetStackRequest.Builder builder() {
    return new GetStackRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetStackRequest GetStackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetStackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetStackRequest instance) {
      return from((_GetStackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetStackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetStackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetStackRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link GetStackRequest GetStackRequest}.
     * @return An immutable instance of GetStackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetStackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetStackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GetStackRequest, some of required attributes are not set " + attributes;
    }
  }
}
