/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.applications._Route;

public final class Route
extends _Route {
    private final String route;

    private Route(Builder builder) {
        this.route = builder.route;
    }

    @Override
    @JsonProperty(value="route")
    public String getRoute() {
        return this.route;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Route && this.equalTo((Route)another);
    }

    private boolean equalTo(Route another) {
        return this.route.equals(another.route);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.route.hashCode();
        return h;
    }

    public String toString() {
        return "Route{route=" + this.route + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Route fromJson(Json json) {
        Builder builder = Route.builder();
        if (json.route != null) {
            builder.route(json.route);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ROUTE = 1L;
        private long initBits = 1L;
        private String route;

        private Builder() {
        }

        public final Builder from(Route instance) {
            return this.from((_Route)instance);
        }

        final Builder from(_Route instance) {
            Objects.requireNonNull(instance, "instance");
            this.route(instance.getRoute());
            return this;
        }

        @JsonProperty(value="route")
        public final Builder route(String route) {
            this.route = Objects.requireNonNull(route, "route");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Route build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Route(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("route");
            }
            return "Cannot build Route, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Route {
        String route;

        Json() {
        }

        @JsonProperty(value="route")
        public void setRoute(String route) {
            this.route = route;
        }

        @Override
        public String getRoute() {
            throw new UnsupportedOperationException();
        }
    }
}

