/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.serviceadmin;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.serviceadmin._EnableServiceAccessRequest;

public final class EnableServiceAccessRequest
extends _EnableServiceAccessRequest {
    private final Duration completionTimeout;
    @Nullable
    private final String organizationName;
    private final String serviceName;
    @Nullable
    private final String servicePlanName;

    private EnableServiceAccessRequest(Builder builder) {
        this.organizationName = builder.organizationName;
        this.serviceName = builder.serviceName;
        this.servicePlanName = builder.servicePlanName;
        this.completionTimeout = builder.completionTimeout != null ? builder.completionTimeout : Objects.requireNonNull(super.getCompletionTimeout(), "completionTimeout");
    }

    @Override
    public Duration getCompletionTimeout() {
        return this.completionTimeout;
    }

    @Override
    @Nullable
    public String getOrganizationName() {
        return this.organizationName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @Nullable
    public String getServicePlanName() {
        return this.servicePlanName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EnableServiceAccessRequest && this.equalTo((EnableServiceAccessRequest)another);
    }

    private boolean equalTo(EnableServiceAccessRequest another) {
        return this.completionTimeout.equals(another.completionTimeout) && Objects.equals(this.organizationName, another.organizationName) && this.serviceName.equals(another.serviceName) && Objects.equals(this.servicePlanName, another.servicePlanName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.completionTimeout.hashCode();
        h += (h << 5) + Objects.hashCode(this.organizationName);
        h += (h << 5) + this.serviceName.hashCode();
        h += (h << 5) + Objects.hashCode(this.servicePlanName);
        return h;
    }

    public String toString() {
        return "EnableServiceAccessRequest{completionTimeout=" + this.completionTimeout + ", organizationName=" + this.organizationName + ", serviceName=" + this.serviceName + ", servicePlanName=" + this.servicePlanName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_NAME = 1L;
        private long initBits = 1L;
        private Duration completionTimeout;
        private String organizationName;
        private String serviceName;
        private String servicePlanName;

        private Builder() {
        }

        public final Builder from(EnableServiceAccessRequest instance) {
            return this.from((_EnableServiceAccessRequest)instance);
        }

        final Builder from(_EnableServiceAccessRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.completionTimeout(instance.getCompletionTimeout());
            String organizationNameValue = instance.getOrganizationName();
            if (organizationNameValue != null) {
                this.organizationName(organizationNameValue);
            }
            this.serviceName(instance.getServiceName());
            String servicePlanNameValue = instance.getServicePlanName();
            if (servicePlanNameValue != null) {
                this.servicePlanName(servicePlanNameValue);
            }
            return this;
        }

        public final Builder completionTimeout(Duration completionTimeout) {
            this.completionTimeout = Objects.requireNonNull(completionTimeout, "completionTimeout");
            return this;
        }

        public final Builder organizationName(@Nullable String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final Builder serviceName(String serviceName) {
            this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder servicePlanName(@Nullable String servicePlanName) {
            this.servicePlanName = servicePlanName;
            return this;
        }

        public EnableServiceAccessRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new EnableServiceAccessRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceName");
            }
            return "Cannot build EnableServiceAccessRequest, some of required attributes are not set " + attributes;
        }
    }
}

