package org.cloudfoundry.operations.serviceadmin;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the list service access operation
 */
@Generated(from = "_ListServiceAccessSettingsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServiceAccessSettingsRequest
    extends org.cloudfoundry.operations.serviceadmin._ListServiceAccessSettingsRequest {
  private final @Nullable String brokerName;
  private final @Nullable String organizationName;
  private final @Nullable String serviceName;

  private ListServiceAccessSettingsRequest(ListServiceAccessSettingsRequest.Builder builder) {
    this.brokerName = builder.brokerName;
    this.organizationName = builder.organizationName;
    this.serviceName = builder.serviceName;
  }

  /**
   * Limit the list to this broker name
   */
  @Override
  public @Nullable String getBrokerName() {
    return brokerName;
  }

  /**
   * Limit the list to this organization name
   */
  @Override
  public @Nullable String getOrganizationName() {
    return organizationName;
  }

  /**
   * Limit the list to this service name
   */
  @Override
  public @Nullable String getServiceName() {
    return serviceName;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceAccessSettingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceAccessSettingsRequest
        && equalTo((ListServiceAccessSettingsRequest) another);
  }

  private boolean equalTo(ListServiceAccessSettingsRequest another) {
    return Objects.equals(brokerName, another.brokerName)
        && Objects.equals(organizationName, another.organizationName)
        && Objects.equals(serviceName, another.serviceName);
  }

  /**
   * Computes a hash code from attributes: {@code brokerName}, {@code organizationName}, {@code serviceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(brokerName);
    h += (h << 5) + Objects.hashCode(organizationName);
    h += (h << 5) + Objects.hashCode(serviceName);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceAccessSettingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceAccessSettingsRequest{"
        + "brokerName=" + brokerName
        + ", organizationName=" + organizationName
        + ", serviceName=" + serviceName
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceAccessSettingsRequest ListServiceAccessSettingsRequest}.
   * <pre>
   * ListServiceAccessSettingsRequest.builder()
   *    .brokerName(String | null) // nullable {@link ListServiceAccessSettingsRequest#getBrokerName() brokerName}
   *    .organizationName(String | null) // nullable {@link ListServiceAccessSettingsRequest#getOrganizationName() organizationName}
   *    .serviceName(String | null) // nullable {@link ListServiceAccessSettingsRequest#getServiceName() serviceName}
   *    .build();
   * </pre>
   * @return A new ListServiceAccessSettingsRequest builder
   */
  public static ListServiceAccessSettingsRequest.Builder builder() {
    return new ListServiceAccessSettingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceAccessSettingsRequest ListServiceAccessSettingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServiceAccessSettingsRequest", generator = "Immutables")
  public static final class Builder {
    private String brokerName;
    private String organizationName;
    private String serviceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceAccessSettingsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceAccessSettingsRequest instance) {
      return from((_ListServiceAccessSettingsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListServiceAccessSettingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListServiceAccessSettingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String brokerNameValue = instance.getBrokerName();
      if (brokerNameValue != null) {
        brokerName(brokerNameValue);
      }
      String organizationNameValue = instance.getOrganizationName();
      if (organizationNameValue != null) {
        organizationName(organizationNameValue);
      }
      String serviceNameValue = instance.getServiceName();
      if (serviceNameValue != null) {
        serviceName(serviceNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceAccessSettingsRequest#getBrokerName() brokerName} attribute.
     * @param brokerName The value for brokerName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder brokerName(@Nullable String brokerName) {
      this.brokerName = brokerName;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceAccessSettingsRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(@Nullable String organizationName) {
      this.organizationName = organizationName;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceAccessSettingsRequest#getServiceName() serviceName} attribute.
     * @param serviceName The value for serviceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceName(@Nullable String serviceName) {
      this.serviceName = serviceName;
      return this;
    }

    /**
     * Builds a new {@link ListServiceAccessSettingsRequest ListServiceAccessSettingsRequest}.
     * @return An immutable instance of ListServiceAccessSettingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceAccessSettingsRequest build() {
      return new ListServiceAccessSettingsRequest(this);
    }
  }
}
