/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.Route;
import org.cloudfoundry.util.tuple.Consumer2;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import reactor.core.Exceptions;

public final class ApplicationManifestUtils {
    private static final int GIBI = 1024;
    private static final Yaml YAML;

    private ApplicationManifestUtils() {
    }

    public static List<ApplicationManifest> read(Path path) {
        return ApplicationManifestUtils.doRead(path.toAbsolutePath());
    }

    public static void write(Path path, ApplicationManifest ... applicationManifests) {
        ApplicationManifestUtils.write(path, Arrays.asList(applicationManifests));
    }

    public static void write(Path path, List<ApplicationManifest> applicationManifests) {
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ApplicationManifestUtils.write(out, applicationManifests);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void write(OutputStream out, ApplicationManifest ... applicationManifests) {
        ApplicationManifestUtils.write(out, Arrays.asList(applicationManifests));
    }

    public static void write(OutputStream out, List<ApplicationManifest> applicationManifests) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out);){
            YAML.dump(Collections.singletonMap("applications", applicationManifests.stream().map(ApplicationManifestUtils::toYaml).collect(Collectors.toList())), (Writer)writer);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static <T> void as(Map<String, Object> payload, String key, Function<Object, T> mapper, Consumer<T> consumer) {
        Optional.ofNullable(payload.get(key)).map(mapper).ifPresent(consumer);
    }

    private static void asBoolean(Map<String, Object> payload, String key, Consumer<Boolean> consumer) {
        ApplicationManifestUtils.as(payload, key, Boolean.class::cast, consumer);
    }

    private static void asInteger(Map<String, Object> payload, String key, Consumer<Integer> consumer) {
        ApplicationManifestUtils.as(payload, key, Integer.class::cast, consumer);
    }

    private static <T> void asList(Map<String, Object> payload, String key, Function<Object, T> mapper, Consumer<T> consumer) {
        ApplicationManifestUtils.as(payload, key, value -> ((List)value).stream(), values -> values.map(mapper).forEach(consumer));
    }

    private static void asListOfString(Map<String, Object> payload, String key, Consumer<String> consumer) {
        ApplicationManifestUtils.asList(payload, key, String.class::cast, consumer);
    }

    private static <T> void asMap(Map<String, Object> payload, String key, Function<Object, T> valueMapper, Consumer2<String, T> consumer) {
        ApplicationManifestUtils.as(payload, key, value -> (Map)value, values -> values.forEach((k, v) -> consumer.accept(k, valueMapper.apply(v))));
    }

    private static void asMapOfStringString(Map<String, Object> payload, String key, Consumer2<String, String> consumer) {
        ApplicationManifestUtils.asMap(payload, key, String::valueOf, consumer);
    }

    private static void asMemoryInteger(Map<String, Object> payload, String key, Consumer<Integer> consumer) {
        ApplicationManifestUtils.as(payload, key, raw -> {
            if (raw instanceof Integer) {
                return (Integer)raw;
            }
            if (raw instanceof String) {
                String text = ((String)raw).toUpperCase();
                if (text.endsWith("G")) {
                    return Integer.parseInt(text.substring(0, text.length() - 1)) * 1024;
                }
                if (text.endsWith("GB")) {
                    return Integer.parseInt(text.substring(0, text.length() - 2)) * 1024;
                }
                if (text.endsWith("M")) {
                    return Integer.parseInt(text.substring(0, text.length() - 1));
                }
                if (text.endsWith("MB")) {
                    return Integer.parseInt(text.substring(0, text.length() - 2));
                }
                return 0;
            }
            return 0;
        }, consumer);
    }

    private static void asString(Map<String, Object> payload, String key, Consumer<String> consumer) {
        ApplicationManifestUtils.as(payload, key, String.class::cast, consumer);
    }

    private static Map<String, Object> deserialize(Path path) {
        AtomicReference<Map> root = new AtomicReference<Map>();
        try (InputStream in = Files.newInputStream(path, StandardOpenOption.READ);){
            root.set((Map)YAML.load(in));
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        ApplicationManifestUtils.asString((Map)root.get(), "inherit", inherit -> {
            Map<String, Object> inherited = ApplicationManifestUtils.deserialize(path.getParent().resolve((String)inherit));
            ApplicationManifestUtils.merge(inherited, (Map)root.get());
            root.set(inherited);
        });
        return (Map)root.get();
    }

    private static List<ApplicationManifest> doRead(Path path) {
        Map<String, Object> root = ApplicationManifestUtils.deserialize(path);
        ApplicationManifest template = ApplicationManifestUtils.getTemplate(path, root);
        return Optional.ofNullable(root.get("applications")).map(value -> ((List)value).stream()).orElseGet(Stream::empty).map(application -> {
            String name = ApplicationManifestUtils.getName(application);
            return ApplicationManifestUtils.toApplicationManifest(application, ApplicationManifest.builder().from(template), path).name(name).build();
        }).collect(Collectors.toList());
    }

    private static Object getEmptyNamedObject(List<Object> array, String name) {
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("name", name);
        array.add(value);
        return value;
    }

    private static String getName(Map<String, Object> raw) {
        return Optional.ofNullable(raw.get("name")).map(String.class::cast).orElseThrow(() -> new IllegalStateException("Application does not contain required 'name' value"));
    }

    private static Map<String, Object> getNamedObject(List<Object> array, String name) {
        return (Map)array.stream().filter(value -> value instanceof Map && name.equals(((Map)value).get("name"))).findFirst().orElseGet(() -> ApplicationManifestUtils.getEmptyNamedObject(array, name));
    }

    private static Route getRoute(Map<String, Object> raw) {
        String route = Optional.ofNullable(raw.get("route")).map(String.class::cast).orElseThrow(() -> new IllegalStateException("Route does not contain required 'route' value"));
        return Route.builder().route(route).build();
    }

    private static ApplicationManifest getTemplate(Path path, Map<String, Object> root) {
        return ApplicationManifestUtils.toApplicationManifest(root, ApplicationManifest.builder(), path).name("template").build();
    }

    private static void merge(Map<String, Object> first, Map<String, Object> second) {
        second.forEach((key, value) -> first.merge((String)key, value, (firstValue, secondValue) -> {
            if (secondValue instanceof Map) {
                ApplicationManifestUtils.merge((Map)firstValue, (Map)secondValue);
                return firstValue;
            }
            if (secondValue instanceof List) {
                ApplicationManifestUtils.merge((List)firstValue, (List)secondValue);
                return firstValue;
            }
            return secondValue;
        }));
    }

    private static void merge(List<Object> first, List<Object> second) {
        second.forEach(element -> {
            if (element instanceof Map) {
                Object name = ((Map)element).get("name");
                if (name != null) {
                    Map<String, Object> named = ApplicationManifestUtils.getNamedObject(first, (String)name);
                    ApplicationManifestUtils.merge(named, (Map)element);
                } else {
                    first.add(element);
                }
            } else {
                first.add(element);
            }
        });
    }

    private static void putIfPresent(Map<String, Object> yaml, String key, Object value) {
        ApplicationManifestUtils.putIfPresent(yaml, key, value, Function.identity());
    }

    private static <T> void putIfPresent(Map<String, Object> yaml, String key, T value, Function<T, Object> valueMapper) {
        Optional.ofNullable(value).map(valueMapper).ifPresent(v -> yaml.put(key, v));
    }

    private static ApplicationManifest.Builder toApplicationManifest(Map<String, Object> application, ApplicationManifest.Builder builder, Path root) {
        ApplicationManifestUtils.asString(application, "buildpack", builder::buildpack);
        ApplicationManifestUtils.asString(application, "command", builder::command);
        ApplicationManifestUtils.asMemoryInteger(application, "disk_quota", builder::disk);
        ApplicationManifestUtils.asString(application, "domain", builder::domain);
        ApplicationManifestUtils.asListOfString(application, "domains", builder::domain);
        ApplicationManifestUtils.asMapOfStringString(application, "env", (Consumer2<String, String>)((Consumer2)builder::environmentVariable));
        ApplicationManifestUtils.asString(application, "health-check-http-endpoint", builder::healthCheckHttpEndpoint);
        ApplicationManifestUtils.asString(application, "health-check-type", healthCheckType -> builder.healthCheckType(ApplicationHealthCheck.from(healthCheckType)));
        ApplicationManifestUtils.asString(application, "host", builder::host);
        ApplicationManifestUtils.asListOfString(application, "hosts", builder::host);
        ApplicationManifestUtils.asInteger(application, "instances", builder::instances);
        ApplicationManifestUtils.asMemoryInteger(application, "memory", builder::memory);
        ApplicationManifestUtils.asString(application, "name", builder::name);
        ApplicationManifestUtils.asBoolean(application, "no-hostname", builder::noHostname);
        ApplicationManifestUtils.asBoolean(application, "no-route", builder::noRoute);
        ApplicationManifestUtils.asString(application, "path", path -> builder.path(root.getParent().resolve((String)path)));
        ApplicationManifestUtils.asBoolean(application, "random-route", builder::randomRoute);
        ApplicationManifestUtils.asList(application, "routes", raw -> ApplicationManifestUtils.getRoute((Map)raw), builder::route);
        ApplicationManifestUtils.asListOfString(application, "services", builder::service);
        ApplicationManifestUtils.asString(application, "stack", builder::stack);
        ApplicationManifestUtils.asInteger(application, "timeout", builder::timeout);
        return builder;
    }

    private static List<Map<String, String>> toRoutesYaml(List<Route> routes) {
        return routes.stream().map(route -> Collections.singletonMap("route", route.getRoute())).collect(Collectors.toList());
    }

    private static Map<String, Object> toYaml(ApplicationManifest applicationManifest) {
        TreeMap<String, Object> yaml = new TreeMap<String, Object>();
        ApplicationManifestUtils.putIfPresent(yaml, "buildpack", applicationManifest.getBuildpack());
        ApplicationManifestUtils.putIfPresent(yaml, "command", applicationManifest.getCommand());
        ApplicationManifestUtils.putIfPresent(yaml, "disk_quota", applicationManifest.getDisk());
        ApplicationManifestUtils.putIfPresent(yaml, "docker", applicationManifest.getDocker());
        ApplicationManifestUtils.putIfPresent(yaml, "domains", applicationManifest.getDomains());
        ApplicationManifestUtils.putIfPresent(yaml, "env", applicationManifest.getEnvironmentVariables());
        ApplicationManifestUtils.putIfPresent(yaml, "health-check-http-endpoint", applicationManifest.getHealthCheckHttpEndpoint());
        ApplicationManifestUtils.putIfPresent(yaml, "health-check-type", applicationManifest.getHealthCheckType().getValue());
        ApplicationManifestUtils.putIfPresent(yaml, "hosts", applicationManifest.getHosts());
        ApplicationManifestUtils.putIfPresent(yaml, "instances", applicationManifest.getInstances());
        ApplicationManifestUtils.putIfPresent(yaml, "memory", applicationManifest.getMemory());
        ApplicationManifestUtils.putIfPresent(yaml, "name", applicationManifest.getName());
        ApplicationManifestUtils.putIfPresent(yaml, "no-hostname", applicationManifest.getNoHostname());
        ApplicationManifestUtils.putIfPresent(yaml, "no-route", applicationManifest.getNoRoute());
        ApplicationManifestUtils.putIfPresent(yaml, "path", applicationManifest.getPath());
        ApplicationManifestUtils.putIfPresent(yaml, "random-route", applicationManifest.getRandomRoute());
        ApplicationManifestUtils.putIfPresent(yaml, "route-path", applicationManifest.getRoutePath());
        ApplicationManifestUtils.putIfPresent(yaml, "routes", applicationManifest.getRoutes(), ApplicationManifestUtils::toRoutesYaml);
        ApplicationManifestUtils.putIfPresent(yaml, "services", applicationManifest.getServices());
        ApplicationManifestUtils.putIfPresent(yaml, "stack", applicationManifest.getStack());
        ApplicationManifestUtils.putIfPresent(yaml, "timeout", applicationManifest.getTimeout());
        return yaml;
    }

    static {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setExplicitStart(true);
        YAML = new Yaml(dumperOptions);
    }
}

