package org.cloudfoundry.operations.applications;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * An application manifest that captures some of the details of how an application is deployed.  See <a href="https://docs.cloudfoundry.org/devguide/deploy-apps/manifest.html">the manifest
 * definition</a> for more details.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ApplicationManifest"})
public final class ApplicationManifest extends org.cloudfoundry.operations.applications._ApplicationManifest {
  private final @Nullable String buildpack;
  private final @Nullable String command;
  private final @Nullable Integer disk;
  private final @Nullable Docker docker;
  private final @Nullable List<String> domains;
  private final @Nullable Map<String, Object> environmentVariables;
  private final @Nullable String healthCheckHttpEndpoint;
  private final @Nullable ApplicationHealthCheck healthCheckType;
  private final @Nullable List<String> hosts;
  private final @Nullable Integer instances;
  private final @Nullable Integer memory;
  private final String name;
  private final @Nullable Boolean noHostname;
  private final @Nullable Boolean noRoute;
  private final @Nullable Path path;
  private final @Nullable Boolean randomRoute;
  private final @Nullable String routePath;
  private final @Nullable List<Route> routes;
  private final @Nullable List<String> services;
  private final @Nullable String stack;
  private final @Nullable Integer timeout;

  private ApplicationManifest(ApplicationManifest.Builder builder) {
    this.buildpack = builder.buildpack;
    this.command = builder.command;
    this.disk = builder.disk;
    this.docker = builder.docker;
    this.domains = builder.domains == null ? null : createUnmodifiableList(true, builder.domains);
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
    this.healthCheckType = builder.healthCheckType;
    this.hosts = builder.hosts == null ? null : createUnmodifiableList(true, builder.hosts);
    this.instances = builder.instances;
    this.memory = builder.memory;
    this.name = builder.name;
    this.noHostname = builder.noHostname;
    this.noRoute = builder.noRoute;
    this.path = builder.path;
    this.randomRoute = builder.randomRoute;
    this.routePath = builder.routePath;
    this.routes = builder.routes == null ? null : createUnmodifiableList(true, builder.routes);
    this.services = builder.services == null ? null : createUnmodifiableList(true, builder.services);
    this.stack = builder.stack;
    this.timeout = builder.timeout;
  }

  /**
   * The buildpack used by the application
   */
  @Override
  public @Nullable String getBuildpack() {
    return buildpack;
  }

  /**
   * The command used to execute the application
   */
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The disk quota in megabytes
   */
  @Override
  public @Nullable Integer getDisk() {
    return disk;
  }

  /**
   * The docker information
   */
  @Override
  public @Nullable Docker getDocker() {
    return docker;
  }

  /**
   * The collection of domains bound to the application
   */
  @Override
  public @Nullable List<String> getDomains() {
    return domains;
  }

  /**
   * The environment variables to set on the application
   */
  @Override
  public @Nullable Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The HTTP health check endpoint
   */
  @Override
  public @Nullable String getHealthCheckHttpEndpoint() {
    return healthCheckHttpEndpoint;
  }

  /**
   * The health check type
   */
  @Override
  public @Nullable ApplicationHealthCheck getHealthCheckType() {
    return healthCheckType;
  }

  /**
   * The collection of hosts bound to the application
   */
  @Override
  public @Nullable List<String> getHosts() {
    return hosts;
  }

  /**
   * The number of instances of the application
   */
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory quota in megabytes
   */
  @Override
  public @Nullable Integer getMemory() {
    return memory;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Map the the root domain to the app
   */
  @Override
  public @Nullable Boolean getNoHostname() {
    return noHostname;
  }

  /**
   * Prevent a route being created for the app
   */
  @Override
  public @Nullable Boolean getNoRoute() {
    return noRoute;
  }

  /**
   * The location of the application
   */
  @Override
  public @Nullable Path getPath() {
    return path;
  }

  /**
   * Generate a random route
   */
  @Override
  public @Nullable Boolean getRandomRoute() {
    return randomRoute;
  }

  /**
   * The route path for all applications
   */
  @Override
  public @Nullable String getRoutePath() {
    return routePath;
  }

  /**
   * The collection of routes bound to the application
   */
  @Override
  public @Nullable List<Route> getRoutes() {
    return routes;
  }

  /**
   * The collection of service names bound to the application
   */
  @Override
  public @Nullable List<String> getServices() {
    return services;
  }

  /**
   * The stack used to run the application
   */
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * The number of seconds allowed for application start
   */
  @Override
  public @Nullable Integer getTimeout() {
    return timeout;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationManifest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationManifest
        && equalTo((ApplicationManifest) another);
  }

  private boolean equalTo(ApplicationManifest another) {
    return Objects.equals(buildpack, another.buildpack)
        && Objects.equals(command, another.command)
        && Objects.equals(disk, another.disk)
        && Objects.equals(docker, another.docker)
        && Objects.equals(domains, another.domains)
        && Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(healthCheckHttpEndpoint, another.healthCheckHttpEndpoint)
        && Objects.equals(healthCheckType, another.healthCheckType)
        && Objects.equals(hosts, another.hosts)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memory, another.memory)
        && name.equals(another.name)
        && Objects.equals(noHostname, another.noHostname)
        && Objects.equals(noRoute, another.noRoute)
        && Objects.equals(path, another.path)
        && Objects.equals(randomRoute, another.randomRoute)
        && Objects.equals(routePath, another.routePath)
        && Objects.equals(routes, another.routes)
        && Objects.equals(services, another.services)
        && Objects.equals(stack, another.stack)
        && Objects.equals(timeout, another.timeout);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code command}, {@code disk}, {@code docker}, {@code domains}, {@code environmentVariables}, {@code healthCheckHttpEndpoint}, {@code healthCheckType}, {@code hosts}, {@code instances}, {@code memory}, {@code name}, {@code noHostname}, {@code noRoute}, {@code path}, {@code randomRoute}, {@code routePath}, {@code routes}, {@code services}, {@code stack}, {@code timeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildpack);
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(disk);
    h += (h << 5) + Objects.hashCode(docker);
    h += (h << 5) + Objects.hashCode(domains);
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(healthCheckHttpEndpoint);
    h += (h << 5) + Objects.hashCode(healthCheckType);
    h += (h << 5) + Objects.hashCode(hosts);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(noHostname);
    h += (h << 5) + Objects.hashCode(noRoute);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(randomRoute);
    h += (h << 5) + Objects.hashCode(routePath);
    h += (h << 5) + Objects.hashCode(routes);
    h += (h << 5) + Objects.hashCode(services);
    h += (h << 5) + Objects.hashCode(stack);
    h += (h << 5) + Objects.hashCode(timeout);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationManifest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationManifest{"
        + "buildpack=" + buildpack
        + ", command=" + command
        + ", disk=" + disk
        + ", docker=" + docker
        + ", domains=" + domains
        + ", environmentVariables=" + environmentVariables
        + ", healthCheckHttpEndpoint=" + healthCheckHttpEndpoint
        + ", healthCheckType=" + healthCheckType
        + ", hosts=" + hosts
        + ", instances=" + instances
        + ", memory=" + memory
        + ", name=" + name
        + ", noHostname=" + noHostname
        + ", noRoute=" + noRoute
        + ", path=" + path
        + ", randomRoute=" + randomRoute
        + ", routePath=" + routePath
        + ", routes=" + routes
        + ", services=" + services
        + ", stack=" + stack
        + ", timeout=" + timeout
        + "}";
  }


  private static ApplicationManifest validate(ApplicationManifest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ApplicationManifest ApplicationManifest}.
   * @return A new ApplicationManifest builder
   */
  public static ApplicationManifest.Builder builder() {
    return new ApplicationManifest.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationManifest ApplicationManifest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String buildpack;
    private String command;
    private Integer disk;
    private Docker docker;
    private List<String> domains = null;
    private Map<String, Object> environmentVariables = null;
    private String healthCheckHttpEndpoint;
    private ApplicationHealthCheck healthCheckType;
    private List<String> hosts = null;
    private Integer instances;
    private Integer memory;
    private String name;
    private Boolean noHostname;
    private Boolean noRoute;
    private Path path;
    private Boolean randomRoute;
    private String routePath;
    private List<Route> routes = null;
    private List<String> services = null;
    private String stack;
    private Integer timeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationManifest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationManifest instance) {
      return from((_ApplicationManifest) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationManifest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationManifest instance) {
      Objects.requireNonNull(instance, "instance");
      String buildpackValue = instance.getBuildpack();
      if (buildpackValue != null) {
        buildpack(buildpackValue);
      }
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      Integer diskValue = instance.getDisk();
      if (diskValue != null) {
        disk(diskValue);
      }
      Docker dockerValue = instance.getDocker();
      if (dockerValue != null) {
        docker(dockerValue);
      }
      List<String> domainsValue = instance.getDomains();
      if (domainsValue != null) {
        addAllDomains(domainsValue);
      }
      Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
      if (environmentVariablesValue != null) {
        putAllEnvironmentVariables(environmentVariablesValue);
      }
      String healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint();
      if (healthCheckHttpEndpointValue != null) {
        healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
      }
      ApplicationHealthCheck healthCheckTypeValue = instance.getHealthCheckType();
      if (healthCheckTypeValue != null) {
        healthCheckType(healthCheckTypeValue);
      }
      List<String> hostsValue = instance.getHosts();
      if (hostsValue != null) {
        addAllHosts(hostsValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      name(instance.getName());
      Boolean noHostnameValue = instance.getNoHostname();
      if (noHostnameValue != null) {
        noHostname(noHostnameValue);
      }
      Boolean noRouteValue = instance.getNoRoute();
      if (noRouteValue != null) {
        noRoute(noRouteValue);
      }
      Path pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Boolean randomRouteValue = instance.getRandomRoute();
      if (randomRouteValue != null) {
        randomRoute(randomRouteValue);
      }
      String routePathValue = instance.getRoutePath();
      if (routePathValue != null) {
        routePath(routePathValue);
      }
      List<Route> routesValue = instance.getRoutes();
      if (routesValue != null) {
        addAllRoutes(routesValue);
      }
      List<String> servicesValue = instance.getServices();
      if (servicesValue != null) {
        addAllServices(servicesValue);
      }
      String stackValue = instance.getStack();
      if (stackValue != null) {
        stack(stackValue);
      }
      Integer timeoutValue = instance.getTimeout();
      if (timeoutValue != null) {
        timeout(timeoutValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getDisk() disk} attribute.
     * @param disk The value for disk (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disk(@Nullable Integer disk) {
      this.disk = disk;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getDocker() docker} attribute.
     * @param docker The value for docker (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder docker(@Nullable Docker docker) {
      this.docker = docker;
      return this;
    }

    /**
     * Adds one element to {@link _ApplicationManifest#getDomains() domains} list.
     * @param element A domains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String element) {
      if (this.domains == null) {
        this.domains = new ArrayList<String>();
      }
      this.domains.add(Objects.requireNonNull(element, "domains element"));
      return this;
    }

    /**
     * Adds elements to {@link _ApplicationManifest#getDomains() domains} list.
     * @param elements An array of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String... elements) {
      if (this.domains == null) {
        this.domains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domains.add(Objects.requireNonNull(element, "domains element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ApplicationManifest#getDomains() domains} list.
     * @param elements An iterable of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domains = null;
        return this;
      }
      this.domains = new ArrayList<String>();
      return addAllDomains(elements);
    }

    /**
     * Adds elements to {@link _ApplicationManifest#getDomains() domains} list.
     * @param elements An iterable of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domains element");
      if (this.domains == null) {
        this.domains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domains.add(Objects.requireNonNull(element, "domains element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationManifest#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationManifest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ApplicationManifest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
      if (environmentVariables == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, Object>();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ApplicationManifest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint} attribute.
     * @param healthCheckHttpEndpoint The value for healthCheckHttpEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
      this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getHealthCheckType() healthCheckType} attribute.
     * @param healthCheckType The value for healthCheckType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckType(@Nullable ApplicationHealthCheck healthCheckType) {
      this.healthCheckType = healthCheckType;
      return this;
    }

    /**
     * Adds one element to {@link _ApplicationManifest#getHosts() hosts} list.
     * @param element A hosts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String element) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      return this;
    }

    /**
     * Adds elements to {@link _ApplicationManifest#getHosts() hosts} list.
     * @param elements An array of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String... elements) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ApplicationManifest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.hosts = null;
        return this;
      }
      this.hosts = new ArrayList<String>();
      return addAllHosts(elements);
    }

    /**
     * Adds elements to {@link _ApplicationManifest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllHosts(Iterable<String> elements) {
      Objects.requireNonNull(elements, "hosts element");
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memory(@Nullable Integer memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getNoHostname() noHostname} attribute.
     * @param noHostname The value for noHostname (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder noHostname(@Nullable Boolean noHostname) {
      this.noHostname = noHostname;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getNoRoute() noRoute} attribute.
     * @param noRoute The value for noRoute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder noRoute(@Nullable Boolean noRoute) {
      this.noRoute = noRoute;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable Path path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getRandomRoute() randomRoute} attribute.
     * @param randomRoute The value for randomRoute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder randomRoute(@Nullable Boolean randomRoute) {
      this.randomRoute = randomRoute;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getRoutePath() routePath} attribute.
     * @param routePath The value for routePath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routePath(@Nullable String routePath) {
      this.routePath = routePath;
      return this;
    }

    /**
     * Adds one element to {@link _ApplicationManifest#getRoutes() routes} list.
     * @param element A routes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder route(Route element) {
      if (this.routes == null) {
        this.routes = new ArrayList<Route>();
      }
      this.routes.add(Objects.requireNonNull(element, "routes element"));
      return this;
    }

    /**
     * Adds elements to {@link _ApplicationManifest#getRoutes() routes} list.
     * @param elements An array of routes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder route(Route... elements) {
      if (this.routes == null) {
        this.routes = new ArrayList<Route>();
      }
      for (Route element : elements) {
        this.routes.add(Objects.requireNonNull(element, "routes element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ApplicationManifest#getRoutes() routes} list.
     * @param elements An iterable of routes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routes(@Nullable Iterable<? extends Route> elements) {
      if (elements == null) {
        this.routes = null;
        return this;
      }
      this.routes = new ArrayList<Route>();
      return addAllRoutes(elements);
    }

    /**
     * Adds elements to {@link _ApplicationManifest#getRoutes() routes} list.
     * @param elements An iterable of routes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRoutes(Iterable<? extends Route> elements) {
      Objects.requireNonNull(elements, "routes element");
      if (this.routes == null) {
        this.routes = new ArrayList<Route>();
      }
      for (Route element : elements) {
        this.routes.add(Objects.requireNonNull(element, "routes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ApplicationManifest#getServices() services} list.
     * @param element A services element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(String element) {
      if (this.services == null) {
        this.services = new ArrayList<String>();
      }
      this.services.add(Objects.requireNonNull(element, "services element"));
      return this;
    }

    /**
     * Adds elements to {@link _ApplicationManifest#getServices() services} list.
     * @param elements An array of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(String... elements) {
      if (this.services == null) {
        this.services = new ArrayList<String>();
      }
      for (String element : elements) {
        this.services.add(Objects.requireNonNull(element, "services element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ApplicationManifest#getServices() services} list.
     * @param elements An iterable of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder services(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.services = null;
        return this;
      }
      this.services = new ArrayList<String>();
      return addAllServices(elements);
    }

    /**
     * Adds elements to {@link _ApplicationManifest#getServices() services} list.
     * @param elements An iterable of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServices(Iterable<String> elements) {
      Objects.requireNonNull(elements, "services element");
      if (this.services == null) {
        this.services = new ArrayList<String>();
      }
      for (String element : elements) {
        this.services.add(Objects.requireNonNull(element, "services element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationManifest#getTimeout() timeout} attribute.
     * @param timeout The value for timeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(@Nullable Integer timeout) {
      this.timeout = timeout;
      return this;
    }

    /**
     * Builds a new {@link ApplicationManifest ApplicationManifest}.
     * @return An immutable instance of ApplicationManifest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationManifest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ApplicationManifest.validate(new ApplicationManifest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ApplicationManifest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
