/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.TaskState;
import org.cloudfoundry.operations.applications._Task;
import org.immutables.value.Generated;

@Generated(from="_Task", generator="Immutables")
public final class Task
extends _Task {
    @Nullable
    private final String command;
    private final String name;
    private final Integer sequenceId;
    private final String startTime;
    private final TaskState state;

    private Task(Builder builder) {
        this.command = builder.command;
        this.name = builder.name;
        this.sequenceId = builder.sequenceId;
        this.startTime = builder.startTime;
        this.state = builder.state;
    }

    @Override
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getSequenceId() {
        return this.sequenceId;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public TaskState getState() {
        return this.state;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Task && this.equalTo((Task)another);
    }

    private boolean equalTo(Task another) {
        return Objects.equals(this.command, another.command) && this.name.equals(another.name) && this.sequenceId.equals(another.sequenceId) && this.startTime.equals(another.startTime) && this.state.equals((Object)another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.sequenceId.hashCode();
        h += (h << 5) + this.startTime.hashCode();
        h += (h << 5) + this.state.hashCode();
        return h;
    }

    public String toString() {
        return "Task{command=" + this.command + ", name=" + this.name + ", sequenceId=" + this.sequenceId + ", startTime=" + this.startTime + ", state=" + (Object)((Object)this.state) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_Task", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SEQUENCE_ID = 2L;
        private static final long INIT_BIT_START_TIME = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private long initBits = 15L;
        private String command;
        private String name;
        private Integer sequenceId;
        private String startTime;
        private TaskState state;

        private Builder() {
        }

        public final Builder from(Task instance) {
            return this.from((_Task)instance);
        }

        final Builder from(_Task instance) {
            Objects.requireNonNull(instance, "instance");
            String commandValue = instance.getCommand();
            if (commandValue != null) {
                this.command(commandValue);
            }
            this.name(instance.getName());
            this.sequenceId(instance.getSequenceId());
            this.startTime(instance.getStartTime());
            this.state(instance.getState());
            return this;
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sequenceId(Integer sequenceId) {
            this.sequenceId = Objects.requireNonNull(sequenceId, "sequenceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder startTime(String startTime) {
            this.startTime = Objects.requireNonNull(startTime, "startTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder state(TaskState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Task build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Task(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sequenceId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("startTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build Task, some of required attributes are not set " + attributes;
        }
    }
}

