/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.List;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.immutables.value.Value;

@Value.Immutable
abstract class _PushApplicationManifestRequest {
    _PushApplicationManifestRequest() {
    }

    @Value.Check
    void check() {
        if (this.getDockerPassword() != null && this.getDockerUsername() == null) {
            throw new IllegalStateException("Docker password requires username");
        }
        if (this.getDockerUsername() != null && this.getDockerPassword() == null) {
            throw new IllegalStateException("Docker username requires password");
        }
    }

    @Nullable
    abstract String getDockerPassword();

    @Nullable
    abstract String getDockerUsername();

    abstract List<ApplicationManifest> getManifests();

    @Nullable
    abstract Boolean getNoStart();

    @Value.Default
    Duration getStagingTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Value.Default
    Duration getStartupTimeout() {
        return Duration.ofMinutes(5L);
    }
}

