/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.buildpacks;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.buildpacks._Buildpack;
import org.immutables.value.Generated;

@Generated(from="_Buildpack", generator="Immutables")
public final class Buildpack
extends _Buildpack {
    private final Boolean enabled;
    @Nullable
    private final String filename;
    private final String id;
    private final Boolean locked;
    private final String name;
    private final Integer position;
    @Nullable
    private final String stack;

    private Buildpack(Builder builder) {
        this.enabled = builder.enabled;
        this.filename = builder.filename;
        this.id = builder.id;
        this.locked = builder.locked;
        this.name = builder.name;
        this.position = builder.position;
        this.stack = builder.stack;
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean getLocked() {
        return this.locked;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    @Nullable
    public String getStack() {
        return this.stack;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Buildpack && this.equalTo((Buildpack)another);
    }

    private boolean equalTo(Buildpack another) {
        return this.enabled.equals(another.enabled) && Objects.equals(this.filename, another.filename) && this.id.equals(another.id) && this.locked.equals(another.locked) && this.name.equals(another.name) && this.position.equals(another.position) && Objects.equals(this.stack, another.stack);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.enabled.hashCode();
        h += (h << 5) + Objects.hashCode(this.filename);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.locked.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.position.hashCode();
        h += (h << 5) + Objects.hashCode(this.stack);
        return h;
    }

    public String toString() {
        return "Buildpack{enabled=" + this.enabled + ", filename=" + this.filename + ", id=" + this.id + ", locked=" + this.locked + ", name=" + this.name + ", position=" + this.position + ", stack=" + this.stack + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_Buildpack", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_LOCKED = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_POSITION = 16L;
        private long initBits = 31L;
        private Boolean enabled;
        private String filename;
        private String id;
        private Boolean locked;
        private String name;
        private Integer position;
        private String stack;

        private Builder() {
        }

        public final Builder from(Buildpack instance) {
            return this.from((_Buildpack)instance);
        }

        final Builder from(_Buildpack instance) {
            Objects.requireNonNull(instance, "instance");
            this.enabled(instance.getEnabled());
            String filenameValue = instance.getFilename();
            if (filenameValue != null) {
                this.filename(filenameValue);
            }
            this.id(instance.getId());
            this.locked(instance.getLocked());
            this.name(instance.getName());
            this.position(instance.getPosition());
            String stackValue = instance.getStack();
            if (stackValue != null) {
                this.stack(stackValue);
            }
            return this;
        }

        public final Builder enabled(Boolean enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder filename(@Nullable String filename) {
            this.filename = filename;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder locked(Boolean locked) {
            this.locked = Objects.requireNonNull(locked, "locked");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder position(Integer position) {
            this.position = Objects.requireNonNull(position, "position");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder stack(@Nullable String stack) {
            this.stack = stack;
            return this;
        }

        public Buildpack build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Buildpack(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("locked");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("position");
            }
            return "Cannot build Buildpack, some of required attributes are not set " + attributes;
        }
    }
}

