/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.routes;

import org.cloudfoundry.Nullable;
import org.immutables.value.Value;

@Value.Immutable
abstract class _CreateRouteRequest {
    _CreateRouteRequest() {
    }

    @Value.Check
    void checkPorts() {
        if (this.getRandomPort() != null && this.getRandomPort().booleanValue() && this.getPort() != null) {
            throw new IllegalStateException("Only one of port and randomPort can be set");
        }
    }

    @Value.Check
    void checkSetup() {
        if (this.portSet() && this.hostOrPathSet()) {
            throw new IllegalStateException("Cannot set port/randomPort and hostname/path");
        }
    }

    abstract String getDomain();

    @Nullable
    abstract String getHost();

    @Nullable
    abstract String getPath();

    @Nullable
    abstract Integer getPort();

    @Nullable
    abstract Boolean getRandomPort();

    abstract String getSpace();

    private boolean hostOrPathSet() {
        return this.getHost() != null || this.getPath() != null;
    }

    private boolean portSet() {
        return this.getRandomPort() != null && this.getRandomPort() != false || this.getPort() != null;
    }
}

