package org.cloudfoundry.operations.serviceadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A Service Broker
 */
@Generated(from = "_ServiceBroker", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceBroker extends org.cloudfoundry.operations.serviceadmin._ServiceBroker {
  private final String id;
  private final String name;
  private final String url;

  private ServiceBroker(ServiceBroker.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.url = builder.url;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name of the service broker
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The url of the service broker
   */
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * This instance is equal to all instances of {@code ServiceBroker} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceBroker
        && equalTo((ServiceBroker) another);
  }

  private boolean equalTo(ServiceBroker another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && url.equals(another.url);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + url.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceBroker} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceBroker{"
        + "id=" + id
        + ", name=" + name
        + ", url=" + url
        + "}";
  }

  /**
   * Creates a builder for {@link ServiceBroker ServiceBroker}.
   * <pre>
   * ServiceBroker.builder()
   *    .id(String) // required {@link ServiceBroker#getId() id}
   *    .name(String) // required {@link ServiceBroker#getName() name}
   *    .url(String) // required {@link ServiceBroker#getUrl() url}
   *    .build();
   * </pre>
   * @return A new ServiceBroker builder
   */
  public static ServiceBroker.Builder builder() {
    return new ServiceBroker.Builder();
  }

  /**
   * Builds instances of type {@link ServiceBroker ServiceBroker}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceBroker", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_URL = 0x4L;
    private long initBits = 0x7L;

    private String id;
    private String name;
    private String url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceBroker} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBroker instance) {
      return from((_ServiceBroker) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceBroker} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceBroker instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      url(instance.getUrl());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBroker#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBroker#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBroker#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Builds a new {@link ServiceBroker ServiceBroker}.
     * @return An immutable instance of ServiceBroker
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceBroker build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceBroker(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      return "Cannot build ServiceBroker, some of required attributes are not set " + attributes;
    }
  }
}
