package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A service key
 */
@Generated(from = "_ServiceKey", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceKey extends org.cloudfoundry.operations.services._ServiceKey {
  private final Map<String, Object> credentials;
  private final String id;
  private final String name;

  private ServiceKey(ServiceKey.Builder builder) {
    this.credentials = createUnmodifiableMap(false, false, builder.credentials);
    this.id = builder.id;
    this.name = builder.name;
  }

  /**
   * The credentials
   */
  @Override
  public Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The service key id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * Service key name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code ServiceKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceKey
        && equalTo((ServiceKey) another);
  }

  private boolean equalTo(ServiceKey another) {
    return credentials.equals(another.credentials)
        && id.equals(another.id)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code id}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + credentials.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceKey} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceKey{"
        + "credentials=" + credentials
        + ", id=" + id
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link ServiceKey ServiceKey}.
   * <pre>
   * ServiceKey.builder()
   *    .credential|putAllCredentials(String => Object) // {@link ServiceKey#getCredentials() credentials} mappings
   *    .id(String) // required {@link ServiceKey#getId() id}
   *    .name(String) // required {@link ServiceKey#getName() name}
   *    .build();
   * </pre>
   * @return A new ServiceKey builder
   */
  public static ServiceKey.Builder builder() {
    return new ServiceKey.Builder();
  }

  /**
   * Builds instances of type {@link ServiceKey ServiceKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceKey", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private Map<String, Object> credentials = new LinkedHashMap<String, Object>();
    private String id;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceKey instance) {
      return from((_ServiceKey) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceKey} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceKey instance) {
      Objects.requireNonNull(instance, "instance");
      putAllCredentials(instance.getCredentials());
      id(instance.getId());
      name(instance.getName());
      return this;
    }

    /**
     * Put one entry to the {@link ServiceKey#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ServiceKey#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ServiceKey#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credentials(Map<String, ? extends Object> entries) {
      this.credentials.clear();
      return putAllCredentials(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ServiceKey#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceKey#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceKey#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ServiceKey ServiceKey}.
     * @return An immutable instance of ServiceKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceKey build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceKey(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ServiceKey, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
