/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.AbstractApplicationSummary;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.cloudfoundry.operations.applications._ApplicationDetail;
import org.immutables.value.Generated;

@Generated(from="_ApplicationDetail", generator="Immutables")
public final class ApplicationDetail
extends _ApplicationDetail {
    private final Integer diskQuota;
    private final String id;
    private final Integer instances;
    private final Integer memoryLimit;
    private final String name;
    private final String requestedState;
    private final Integer runningInstances;
    private final List<String> urls;
    @Nullable
    private final String buildpack;
    private final List<InstanceDetail> instanceDetails;
    @Nullable
    private final Date lastUploaded;
    private final String stack;

    private ApplicationDetail(Builder builder) {
        this.diskQuota = builder.diskQuota;
        this.id = builder.id;
        this.instances = builder.instances;
        this.memoryLimit = builder.memoryLimit;
        this.name = builder.name;
        this.requestedState = builder.requestedState;
        this.runningInstances = builder.runningInstances;
        this.urls = ApplicationDetail.createUnmodifiableList(true, builder.urls);
        this.buildpack = builder.buildpack;
        this.instanceDetails = ApplicationDetail.createUnmodifiableList(true, builder.instanceDetails);
        this.lastUploaded = builder.lastUploaded;
        this.stack = builder.stack;
    }

    @Override
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRequestedState() {
        return this.requestedState;
    }

    @Override
    public Integer getRunningInstances() {
        return this.runningInstances;
    }

    @Override
    public List<String> getUrls() {
        return this.urls;
    }

    @Override
    @Nullable
    public String getBuildpack() {
        return this.buildpack;
    }

    @Override
    public List<InstanceDetail> getInstanceDetails() {
        return this.instanceDetails;
    }

    @Override
    @Nullable
    public Date getLastUploaded() {
        return this.lastUploaded;
    }

    @Override
    public String getStack() {
        return this.stack;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationDetail && this.equalTo((ApplicationDetail)another);
    }

    private boolean equalTo(ApplicationDetail another) {
        return this.diskQuota.equals(another.diskQuota) && this.id.equals(another.id) && this.instances.equals(another.instances) && this.memoryLimit.equals(another.memoryLimit) && this.name.equals(another.name) && this.requestedState.equals(another.requestedState) && this.runningInstances.equals(another.runningInstances) && this.urls.equals(another.urls) && Objects.equals(this.buildpack, another.buildpack) && this.instanceDetails.equals(another.instanceDetails) && Objects.equals(this.lastUploaded, another.lastUploaded) && this.stack.equals(another.stack);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.diskQuota.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.instances.hashCode();
        h += (h << 5) + this.memoryLimit.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.requestedState.hashCode();
        h += (h << 5) + this.runningInstances.hashCode();
        h += (h << 5) + this.urls.hashCode();
        h += (h << 5) + Objects.hashCode(this.buildpack);
        h += (h << 5) + this.instanceDetails.hashCode();
        h += (h << 5) + Objects.hashCode(this.lastUploaded);
        h += (h << 5) + this.stack.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationDetail{diskQuota=" + this.diskQuota + ", id=" + this.id + ", instances=" + this.instances + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", requestedState=" + this.requestedState + ", runningInstances=" + this.runningInstances + ", urls=" + this.urls + ", buildpack=" + this.buildpack + ", instanceDetails=" + this.instanceDetails + ", lastUploaded=" + this.lastUploaded + ", stack=" + this.stack + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ApplicationDetail", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DISK_QUOTA = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_INSTANCES = 4L;
        private static final long INIT_BIT_MEMORY_LIMIT = 8L;
        private static final long INIT_BIT_NAME = 16L;
        private static final long INIT_BIT_REQUESTED_STATE = 32L;
        private static final long INIT_BIT_RUNNING_INSTANCES = 64L;
        private static final long INIT_BIT_STACK = 128L;
        private long initBits = 255L;
        private Integer diskQuota;
        private String id;
        private Integer instances;
        private Integer memoryLimit;
        private String name;
        private String requestedState;
        private Integer runningInstances;
        private List<String> urls = new ArrayList<String>();
        private String buildpack;
        private List<InstanceDetail> instanceDetails = new ArrayList<InstanceDetail>();
        private Date lastUploaded;
        private String stack;

        private Builder() {
        }

        public final Builder from(AbstractApplicationSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ApplicationDetail instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ApplicationDetail instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractApplicationSummary instance;
            if (object instanceof AbstractApplicationSummary) {
                instance = (AbstractApplicationSummary)object;
                this.addAllUrls(instance.getUrls());
                this.instances(instance.getInstances());
                this.requestedState(instance.getRequestedState());
                this.name(instance.getName());
                this.memoryLimit(instance.getMemoryLimit());
                this.id(instance.getId());
                this.diskQuota(instance.getDiskQuota());
                this.runningInstances(instance.getRunningInstances());
            }
            if (object instanceof _ApplicationDetail) {
                String buildpackValue;
                instance = (_ApplicationDetail)object;
                this.stack(((_ApplicationDetail)instance).getStack());
                Date lastUploadedValue = ((_ApplicationDetail)instance).getLastUploaded();
                if (lastUploadedValue != null) {
                    this.lastUploaded(lastUploadedValue);
                }
                if ((buildpackValue = ((_ApplicationDetail)instance).getBuildpack()) != null) {
                    this.buildpack(buildpackValue);
                }
                this.addAllInstanceDetails(((_ApplicationDetail)instance).getInstanceDetails());
            }
        }

        public final Builder diskQuota(Integer diskQuota) {
            this.diskQuota = Objects.requireNonNull(diskQuota, "diskQuota");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder instances(Integer instances) {
            this.instances = Objects.requireNonNull(instances, "instances");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder memoryLimit(Integer memoryLimit) {
            this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder requestedState(String requestedState) {
            this.requestedState = Objects.requireNonNull(requestedState, "requestedState");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder runningInstances(Integer runningInstances) {
            this.runningInstances = Objects.requireNonNull(runningInstances, "runningInstances");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder url(String element) {
            this.urls.add(Objects.requireNonNull(element, "urls element"));
            return this;
        }

        public final Builder urls(String ... elements) {
            for (String element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        public final Builder urls(Iterable<String> elements) {
            this.urls.clear();
            return this.addAllUrls(elements);
        }

        public final Builder addAllUrls(Iterable<String> elements) {
            for (String element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        public final Builder buildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public final Builder instanceDetail(InstanceDetail element) {
            this.instanceDetails.add(Objects.requireNonNull(element, "instanceDetails element"));
            return this;
        }

        public final Builder instanceDetails(InstanceDetail ... elements) {
            for (InstanceDetail element : elements) {
                this.instanceDetails.add(Objects.requireNonNull(element, "instanceDetails element"));
            }
            return this;
        }

        public final Builder instanceDetails(Iterable<? extends InstanceDetail> elements) {
            this.instanceDetails.clear();
            return this.addAllInstanceDetails(elements);
        }

        public final Builder addAllInstanceDetails(Iterable<? extends InstanceDetail> elements) {
            for (InstanceDetail instanceDetail : elements) {
                this.instanceDetails.add(Objects.requireNonNull(instanceDetail, "instanceDetails element"));
            }
            return this;
        }

        public final Builder lastUploaded(@Nullable Date lastUploaded) {
            this.lastUploaded = lastUploaded;
            return this;
        }

        public final Builder stack(String stack) {
            this.stack = Objects.requireNonNull(stack, "stack");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ApplicationDetail build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ApplicationDetail(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("diskQuota");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("instances");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("memoryLimit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("requestedState");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("runningInstances");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("stack");
            }
            return "Cannot build ApplicationDetail, some of required attributes are not set " + attributes;
        }
    }
}

