package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Application as returned by get
 */
@Generated(from = "_ApplicationDetail", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplicationDetail extends org.cloudfoundry.operations.applications._ApplicationDetail {
  private final Integer diskQuota;
  private final String id;
  private final Integer instances;
  private final Integer memoryLimit;
  private final String name;
  private final String requestedState;
  private final Integer runningInstances;
  private final List<String> urls;
  private final @Nullable String buildpack;
  private final List<InstanceDetail> instanceDetails;
  private final @Nullable Date lastUploaded;
  private final String stack;

  private ApplicationDetail(ApplicationDetail.Builder builder) {
    this.diskQuota = builder.diskQuota;
    this.id = builder.id;
    this.instances = builder.instances;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.requestedState = builder.requestedState;
    this.runningInstances = builder.runningInstances;
    this.urls = createUnmodifiableList(true, builder.urls);
    this.buildpack = builder.buildpack;
    this.instanceDetails = createUnmodifiableList(true, builder.instanceDetails);
    this.lastUploaded = builder.lastUploaded;
    this.stack = builder.stack;
  }

  /**
   * The disk quota in bytes
   */
  @Override
  public Integer getDiskQuota() {
    return diskQuota;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The number of instances
   */
  @Override
  public Integer getInstances() {
    return instances;
  }

  /**
   * The memory limit in bytes
   */
  @Override
  public Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The requested state
   */
  @Override
  public String getRequestedState() {
    return requestedState;
  }

  /**
   * The number of running instances
   */
  @Override
  public Integer getRunningInstances() {
    return runningInstances;
  }

  /**
   * The list of bound urls
   */
  @Override
  public List<String> getUrls() {
    return urls;
  }

  /**
   * The buildpack, if any, used to stage this application
   */
  @Override
  public @Nullable String getBuildpack() {
    return buildpack;
  }

  /**
   * The list of instances
   */
  @Override
  public List<InstanceDetail> getInstanceDetails() {
    return instanceDetails;
  }

  /**
   * The time the application was last updated
   */
  @Override
  public @Nullable Date getLastUploaded() {
    return lastUploaded;
  }

  /**
   * The name of the stack running the application
   */
  @Override
  public String getStack() {
    return stack;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationDetail
        && equalTo((ApplicationDetail) another);
  }

  private boolean equalTo(ApplicationDetail another) {
    return diskQuota.equals(another.diskQuota)
        && id.equals(another.id)
        && instances.equals(another.instances)
        && memoryLimit.equals(another.memoryLimit)
        && name.equals(another.name)
        && requestedState.equals(another.requestedState)
        && runningInstances.equals(another.runningInstances)
        && urls.equals(another.urls)
        && Objects.equals(buildpack, another.buildpack)
        && instanceDetails.equals(another.instanceDetails)
        && Objects.equals(lastUploaded, another.lastUploaded)
        && stack.equals(another.stack);
  }

  /**
   * Computes a hash code from attributes: {@code diskQuota}, {@code id}, {@code instances}, {@code memoryLimit}, {@code name}, {@code requestedState}, {@code runningInstances}, {@code urls}, {@code buildpack}, {@code instanceDetails}, {@code lastUploaded}, {@code stack}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + diskQuota.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + instances.hashCode();
    h += (h << 5) + memoryLimit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + requestedState.hashCode();
    h += (h << 5) + runningInstances.hashCode();
    h += (h << 5) + urls.hashCode();
    h += (h << 5) + Objects.hashCode(buildpack);
    h += (h << 5) + instanceDetails.hashCode();
    h += (h << 5) + Objects.hashCode(lastUploaded);
    h += (h << 5) + stack.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationDetail{"
        + "diskQuota=" + diskQuota
        + ", id=" + id
        + ", instances=" + instances
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", requestedState=" + requestedState
        + ", runningInstances=" + runningInstances
        + ", urls=" + urls
        + ", buildpack=" + buildpack
        + ", instanceDetails=" + instanceDetails
        + ", lastUploaded=" + lastUploaded
        + ", stack=" + stack
        + "}";
  }

  /**
   * Creates a builder for {@link ApplicationDetail ApplicationDetail}.
   * <pre>
   * ApplicationDetail.builder()
   *    .diskQuota(Integer) // required {@link ApplicationDetail#getDiskQuota() diskQuota}
   *    .id(String) // required {@link ApplicationDetail#getId() id}
   *    .instances(Integer) // required {@link ApplicationDetail#getInstances() instances}
   *    .memoryLimit(Integer) // required {@link ApplicationDetail#getMemoryLimit() memoryLimit}
   *    .name(String) // required {@link ApplicationDetail#getName() name}
   *    .requestedState(String) // required {@link ApplicationDetail#getRequestedState() requestedState}
   *    .runningInstances(Integer) // required {@link ApplicationDetail#getRunningInstances() runningInstances}
   *    .url|addAllUrls(String) // {@link ApplicationDetail#getUrls() urls} elements
   *    .buildpack(String | null) // nullable {@link ApplicationDetail#getBuildpack() buildpack}
   *    .instanceDetail|addAllInstanceDetails(InstanceDetail) // {@link ApplicationDetail#getInstanceDetails() instanceDetails} elements
   *    .lastUploaded(Date | null) // nullable {@link ApplicationDetail#getLastUploaded() lastUploaded}
   *    .stack(String) // required {@link ApplicationDetail#getStack() stack}
   *    .build();
   * </pre>
   * @return A new ApplicationDetail builder
   */
  public static ApplicationDetail.Builder builder() {
    return new ApplicationDetail.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationDetail ApplicationDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplicationDetail", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DISK_QUOTA = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_INSTANCES = 0x4L;
    private static final long INIT_BIT_MEMORY_LIMIT = 0x8L;
    private static final long INIT_BIT_NAME = 0x10L;
    private static final long INIT_BIT_REQUESTED_STATE = 0x20L;
    private static final long INIT_BIT_RUNNING_INSTANCES = 0x40L;
    private static final long INIT_BIT_STACK = 0x80L;
    private long initBits = 0xffL;

    private Integer diskQuota;
    private String id;
    private Integer instances;
    private Integer memoryLimit;
    private String name;
    private String requestedState;
    private Integer runningInstances;
    private List<String> urls = new ArrayList<String>();
    private String buildpack;
    private List<InstanceDetail> instanceDetails = new ArrayList<InstanceDetail>();
    private Date lastUploaded;
    private String stack;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.operations.applications.AbstractApplicationSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractApplicationSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationDetail} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationDetail instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ApplicationDetail} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ApplicationDetail instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractApplicationSummary) {
        AbstractApplicationSummary instance = (AbstractApplicationSummary) object;
        addAllUrls(instance.getUrls());
        instances(instance.getInstances());
        requestedState(instance.getRequestedState());
        name(instance.getName());
        memoryLimit(instance.getMemoryLimit());
        id(instance.getId());
        diskQuota(instance.getDiskQuota());
        runningInstances(instance.getRunningInstances());
      }
      if (object instanceof org.cloudfoundry.operations.applications._ApplicationDetail) {
        org.cloudfoundry.operations.applications._ApplicationDetail instance = (org.cloudfoundry.operations.applications._ApplicationDetail) object;
        stack(instance.getStack());
        Date lastUploadedValue = instance.getLastUploaded();
        if (lastUploadedValue != null) {
          lastUploaded(lastUploadedValue);
        }
        String buildpackValue = instance.getBuildpack();
        if (buildpackValue != null) {
          buildpack(buildpackValue);
        }
        addAllInstanceDetails(instance.getInstanceDetails());
      }
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskQuota(Integer diskQuota) {
      this.diskQuota = Objects.requireNonNull(diskQuota, "diskQuota");
      initBits &= ~INIT_BIT_DISK_QUOTA;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getInstances() instances} attribute.
     * @param instances The value for instances 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(Integer instances) {
      this.instances = Objects.requireNonNull(instances, "instances");
      initBits &= ~INIT_BIT_INSTANCES;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(Integer memoryLimit) {
      this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
      initBits &= ~INIT_BIT_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getRequestedState() requestedState} attribute.
     * @param requestedState The value for requestedState 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestedState(String requestedState) {
      this.requestedState = Objects.requireNonNull(requestedState, "requestedState");
      initBits &= ~INIT_BIT_REQUESTED_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getRunningInstances() runningInstances} attribute.
     * @param runningInstances The value for runningInstances 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningInstances(Integer runningInstances) {
      this.runningInstances = Objects.requireNonNull(runningInstances, "runningInstances");
      initBits &= ~INIT_BIT_RUNNING_INSTANCES;
      return this;
    }

    /**
     * Adds one element to {@link ApplicationDetail#getUrls() urls} list.
     * @param element A urls element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder url(String element) {
      this.urls.add(Objects.requireNonNull(element, "urls element"));
      return this;
    }

    /**
     * Adds elements to {@link ApplicationDetail#getUrls() urls} list.
     * @param elements An array of urls elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder urls(String... elements) {
      for (String element : elements) {
        this.urls.add(Objects.requireNonNull(element, "urls element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ApplicationDetail#getUrls() urls} list.
     * @param elements An iterable of urls elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder urls(Iterable<String> elements) {
      this.urls.clear();
      return addAllUrls(elements);
    }

    /**
     * Adds elements to {@link ApplicationDetail#getUrls() urls} list.
     * @param elements An iterable of urls elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUrls(Iterable<String> elements) {
      for (String element : elements) {
        this.urls.add(Objects.requireNonNull(element, "urls element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Adds one element to {@link ApplicationDetail#getInstanceDetails() instanceDetails} list.
     * @param element A instanceDetails element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceDetail(InstanceDetail element) {
      this.instanceDetails.add(Objects.requireNonNull(element, "instanceDetails element"));
      return this;
    }

    /**
     * Adds elements to {@link ApplicationDetail#getInstanceDetails() instanceDetails} list.
     * @param elements An array of instanceDetails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceDetails(InstanceDetail... elements) {
      for (InstanceDetail element : elements) {
        this.instanceDetails.add(Objects.requireNonNull(element, "instanceDetails element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ApplicationDetail#getInstanceDetails() instanceDetails} list.
     * @param elements An iterable of instanceDetails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceDetails(Iterable<? extends InstanceDetail> elements) {
      this.instanceDetails.clear();
      return addAllInstanceDetails(elements);
    }

    /**
     * Adds elements to {@link ApplicationDetail#getInstanceDetails() instanceDetails} list.
     * @param elements An iterable of instanceDetails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInstanceDetails(Iterable<? extends InstanceDetail> elements) {
      for (InstanceDetail element : elements) {
        this.instanceDetails.add(Objects.requireNonNull(element, "instanceDetails element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getLastUploaded() lastUploaded} attribute.
     * @param lastUploaded The value for lastUploaded (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lastUploaded(@Nullable Date lastUploaded) {
      this.lastUploaded = lastUploaded;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationDetail#getStack() stack} attribute.
     * @param stack The value for stack 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stack(String stack) {
      this.stack = Objects.requireNonNull(stack, "stack");
      initBits &= ~INIT_BIT_STACK;
      return this;
    }

    /**
     * Builds a new {@link ApplicationDetail ApplicationDetail}.
     * @return An immutable instance of ApplicationDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationDetail build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ApplicationDetail(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DISK_QUOTA) != 0) attributes.add("diskQuota");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_INSTANCES) != 0) attributes.add("instances");
      if ((initBits & INIT_BIT_MEMORY_LIMIT) != 0) attributes.add("memoryLimit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_REQUESTED_STATE) != 0) attributes.add("requestedState");
      if ((initBits & INIT_BIT_RUNNING_INSTANCES) != 0) attributes.add("runningInstances");
      if ((initBits & INIT_BIT_STACK) != 0) attributes.add("stack");
      return "Cannot build ApplicationDetail, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
