package org.cloudfoundry.operations.networkpolicies;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the add network policy operation
 */
@Generated(from = "_AddNetworkPolicyRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AddNetworkPolicyRequest
    extends org.cloudfoundry.operations.networkpolicies._AddNetworkPolicyRequest {
  private final String destination;
  private final @Nullable Integer endPort;
  private final @Nullable String protocol;
  private final String source;
  private final @Nullable Integer startPort;

  private AddNetworkPolicyRequest(AddNetworkPolicyRequest.Builder builder) {
    this.destination = builder.destination;
    this.endPort = builder.endPort;
    this.protocol = builder.protocol;
    this.source = builder.source;
    this.startPort = builder.startPort;
  }

  /**
   * Name of the destination
   */
  @Override
  public String getDestination() {
    return destination;
  }

  /**
   * End of the port range
   */
  @Override
  public @Nullable Integer getEndPort() {
    return endPort;
  }

  /**
   * The protocol
   */
  @Override
  public @Nullable String getProtocol() {
    return protocol;
  }

  /**
   * Name of the source
   */
  @Override
  public String getSource() {
    return source;
  }

  /**
   * Start of the port range
   */
  @Override
  public @Nullable Integer getStartPort() {
    return startPort;
  }

  /**
   * This instance is equal to all instances of {@code AddNetworkPolicyRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AddNetworkPolicyRequest
        && equalTo((AddNetworkPolicyRequest) another);
  }

  private boolean equalTo(AddNetworkPolicyRequest another) {
    return destination.equals(another.destination)
        && Objects.equals(endPort, another.endPort)
        && Objects.equals(protocol, another.protocol)
        && source.equals(another.source)
        && Objects.equals(startPort, another.startPort);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code endPort}, {@code protocol}, {@code source}, {@code startPort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + Objects.hashCode(endPort);
    h += (h << 5) + Objects.hashCode(protocol);
    h += (h << 5) + source.hashCode();
    h += (h << 5) + Objects.hashCode(startPort);
    return h;
  }

  /**
   * Prints the immutable value {@code AddNetworkPolicyRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AddNetworkPolicyRequest{"
        + "destination=" + destination
        + ", endPort=" + endPort
        + ", protocol=" + protocol
        + ", source=" + source
        + ", startPort=" + startPort
        + "}";
  }

  /**
   * Creates a builder for {@link AddNetworkPolicyRequest AddNetworkPolicyRequest}.
   * <pre>
   * AddNetworkPolicyRequest.builder()
   *    .destination(String) // required {@link AddNetworkPolicyRequest#getDestination() destination}
   *    .endPort(Integer | null) // nullable {@link AddNetworkPolicyRequest#getEndPort() endPort}
   *    .protocol(String | null) // nullable {@link AddNetworkPolicyRequest#getProtocol() protocol}
   *    .source(String) // required {@link AddNetworkPolicyRequest#getSource() source}
   *    .startPort(Integer | null) // nullable {@link AddNetworkPolicyRequest#getStartPort() startPort}
   *    .build();
   * </pre>
   * @return A new AddNetworkPolicyRequest builder
   */
  public static AddNetworkPolicyRequest.Builder builder() {
    return new AddNetworkPolicyRequest.Builder();
  }

  /**
   * Builds instances of type {@link AddNetworkPolicyRequest AddNetworkPolicyRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AddNetworkPolicyRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private static final long INIT_BIT_SOURCE = 0x2L;
    private long initBits = 0x3L;

    private String destination;
    private Integer endPort;
    private String protocol;
    private String source;
    private Integer startPort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AddNetworkPolicyRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AddNetworkPolicyRequest instance) {
      return from((_AddNetworkPolicyRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AddNetworkPolicyRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AddNetworkPolicyRequest instance) {
      Objects.requireNonNull(instance, "instance");
      destination(instance.getDestination());
      Integer endPortValue = instance.getEndPort();
      if (endPortValue != null) {
        endPort(endPortValue);
      }
      String protocolValue = instance.getProtocol();
      if (protocolValue != null) {
        protocol(protocolValue);
      }
      source(instance.getSource());
      Integer startPortValue = instance.getStartPort();
      if (startPortValue != null) {
        startPort(startPortValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AddNetworkPolicyRequest#getDestination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(String destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link AddNetworkPolicyRequest#getEndPort() endPort} attribute.
     * @param endPort The value for endPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder endPort(@Nullable Integer endPort) {
      this.endPort = endPort;
      return this;
    }

    /**
     * Initializes the value for the {@link AddNetworkPolicyRequest#getProtocol() protocol} attribute.
     * @param protocol The value for protocol (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocol(@Nullable String protocol) {
      this.protocol = protocol;
      return this;
    }

    /**
     * Initializes the value for the {@link AddNetworkPolicyRequest#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link AddNetworkPolicyRequest#getStartPort() startPort} attribute.
     * @param startPort The value for startPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startPort(@Nullable Integer startPort) {
      this.startPort = startPort;
      return this;
    }

    /**
     * Builds a new {@link AddNetworkPolicyRequest AddNetworkPolicyRequest}.
     * @return An immutable instance of AddNetworkPolicyRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AddNetworkPolicyRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AddNetworkPolicyRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      return "Cannot build AddNetworkPolicyRequest, some of required attributes are not set " + attributes;
    }
  }
}
