/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._ApplicationEvent;
import org.immutables.value.Generated;

@Generated(from="_ApplicationEvent", generator="Immutables")
public final class ApplicationEvent
extends _ApplicationEvent {
    private final String actor;
    private final String description;
    private final String event;
    private final String id;
    @Nullable
    private final Date time;

    private ApplicationEvent(Builder builder) {
        this.actor = builder.actor;
        this.description = builder.description;
        this.event = builder.event;
        this.id = builder.id;
        this.time = builder.time;
    }

    @Override
    public String getActor() {
        return this.actor;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Date getTime() {
        return this.time;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationEvent && this.equalTo((ApplicationEvent)another);
    }

    private boolean equalTo(ApplicationEvent another) {
        return this.actor.equals(another.actor) && this.description.equals(another.description) && this.event.equals(another.event) && this.id.equals(another.id) && Objects.equals(this.time, another.time);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.actor.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.event.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.time);
        return h;
    }

    public String toString() {
        return "ApplicationEvent{actor=" + this.actor + ", description=" + this.description + ", event=" + this.event + ", id=" + this.id + ", time=" + this.time + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_ApplicationEvent", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACTOR = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_EVENT = 4L;
        private static final long INIT_BIT_ID = 8L;
        private long initBits = 15L;
        private String actor;
        private String description;
        private String event;
        private String id;
        private Date time;

        private Builder() {
        }

        public final Builder from(ApplicationEvent instance) {
            return this.from((_ApplicationEvent)instance);
        }

        final Builder from(_ApplicationEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.actor(instance.getActor());
            this.description(instance.getDescription());
            this.event(instance.getEvent());
            this.id(instance.getId());
            Date timeValue = instance.getTime();
            if (timeValue != null) {
                this.time(timeValue);
            }
            return this;
        }

        public final Builder actor(String actor) {
            this.actor = Objects.requireNonNull(actor, "actor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder event(String event) {
            this.event = Objects.requireNonNull(event, "event");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder time(@Nullable Date time) {
            this.time = time;
            return this;
        }

        public ApplicationEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ApplicationEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("actor");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("event");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ApplicationEvent, some of required attributes are not set " + attributes;
        }
    }
}

