package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Represents a task
 */
@Generated(from = "_Task", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Task extends org.cloudfoundry.operations.applications._Task {
  private final @Nullable String command;
  private final String name;
  private final Integer sequenceId;
  private final String startTime;
  private final TaskState state;

  private Task(Task.Builder builder) {
    this.command = builder.command;
    this.name = builder.name;
    this.sequenceId = builder.sequenceId;
    this.startTime = builder.startTime;
    this.state = builder.state;
  }

  /**
   * The command for the task
   */
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The name of the task
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The sequence id of the task
   */
  @Override
  public Integer getSequenceId() {
    return sequenceId;
  }

  /**
   * The start time of the task
   */
  @Override
  public String getStartTime() {
    return startTime;
  }

  /**
   * The state of the task
   */
  @Override
  public TaskState getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code Task} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Task
        && equalTo((Task) another);
  }

  private boolean equalTo(Task another) {
    return Objects.equals(command, another.command)
        && name.equals(another.name)
        && sequenceId.equals(another.sequenceId)
        && startTime.equals(another.startTime)
        && state.equals(another.state);
  }

  /**
   * Computes a hash code from attributes: {@code command}, {@code name}, {@code sequenceId}, {@code startTime}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + sequenceId.hashCode();
    h += (h << 5) + startTime.hashCode();
    h += (h << 5) + state.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Task} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Task{"
        + "command=" + command
        + ", name=" + name
        + ", sequenceId=" + sequenceId
        + ", startTime=" + startTime
        + ", state=" + state
        + "}";
  }

  /**
   * Creates a builder for {@link Task Task}.
   * <pre>
   * Task.builder()
   *    .command(String | null) // nullable {@link Task#getCommand() command}
   *    .name(String) // required {@link Task#getName() name}
   *    .sequenceId(Integer) // required {@link Task#getSequenceId() sequenceId}
   *    .startTime(String) // required {@link Task#getStartTime() startTime}
   *    .state(org.cloudfoundry.operations.applications.TaskState) // required {@link Task#getState() state}
   *    .build();
   * </pre>
   * @return A new Task builder
   */
  public static Task.Builder builder() {
    return new Task.Builder();
  }

  /**
   * Builds instances of type {@link Task Task}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Task", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SEQUENCE_ID = 0x2L;
    private static final long INIT_BIT_START_TIME = 0x4L;
    private static final long INIT_BIT_STATE = 0x8L;
    private long initBits = 0xfL;

    private String command;
    private String name;
    private Integer sequenceId;
    private String startTime;
    private TaskState state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Task} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Task instance) {
      return from((_Task) instance);
    }

    /**
     * Copy abstract value type {@code _Task} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Task instance) {
      Objects.requireNonNull(instance, "instance");
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      name(instance.getName());
      sequenceId(instance.getSequenceId());
      startTime(instance.getStartTime());
      state(instance.getState());
      return this;
    }

    /**
     * Initializes the value for the {@link Task#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link Task#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Task#getSequenceId() sequenceId} attribute.
     * @param sequenceId The value for sequenceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sequenceId(Integer sequenceId) {
      this.sequenceId = Objects.requireNonNull(sequenceId, "sequenceId");
      initBits &= ~INIT_BIT_SEQUENCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Task#getStartTime() startTime} attribute.
     * @param startTime The value for startTime 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startTime(String startTime) {
      this.startTime = Objects.requireNonNull(startTime, "startTime");
      initBits &= ~INIT_BIT_START_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link Task#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(TaskState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Builds a new {@link Task Task}.
     * @return An immutable instance of Task
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Task build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Task(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SEQUENCE_ID) != 0) attributes.add("sequenceId");
      if ((initBits & INIT_BIT_START_TIME) != 0) attributes.add("startTime");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      return "Cannot build Task, some of required attributes are not set " + attributes;
    }
  }
}
