/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.applications.AbstractApplicationResource;
import org.cloudfoundry.client.v2.applications.ApplicationEntity;
import org.cloudfoundry.client.v2.applications.ApplicationEnvironmentRequest;
import org.cloudfoundry.client.v2.applications.ApplicationEnvironmentResponse;
import org.cloudfoundry.client.v2.applications.ApplicationInstanceInfo;
import org.cloudfoundry.client.v2.applications.ApplicationInstancesRequest;
import org.cloudfoundry.client.v2.applications.ApplicationInstancesResponse;
import org.cloudfoundry.client.v2.applications.ApplicationStatisticsRequest;
import org.cloudfoundry.client.v2.applications.ApplicationStatisticsResponse;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteResponse;
import org.cloudfoundry.client.v2.applications.CopyApplicationRequest;
import org.cloudfoundry.client.v2.applications.CopyApplicationResponse;
import org.cloudfoundry.client.v2.applications.CreateApplicationRequest;
import org.cloudfoundry.client.v2.applications.CreateApplicationResponse;
import org.cloudfoundry.client.v2.applications.DockerCredentials;
import org.cloudfoundry.client.v2.applications.InstanceStatistics;
import org.cloudfoundry.client.v2.applications.ListApplicationRoutesRequest;
import org.cloudfoundry.client.v2.applications.ListApplicationServiceBindingsRequest;
import org.cloudfoundry.client.v2.applications.RemoveApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.RemoveApplicationServiceBindingRequest;
import org.cloudfoundry.client.v2.applications.Resource;
import org.cloudfoundry.client.v2.applications.RestageApplicationResponse;
import org.cloudfoundry.client.v2.applications.Statistics;
import org.cloudfoundry.client.v2.applications.SummaryApplicationRequest;
import org.cloudfoundry.client.v2.applications.SummaryApplicationResponse;
import org.cloudfoundry.client.v2.applications.TerminateApplicationInstanceRequest;
import org.cloudfoundry.client.v2.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v2.applications.UploadApplicationRequest;
import org.cloudfoundry.client.v2.applications.UploadApplicationResponse;
import org.cloudfoundry.client.v2.applications.Usage;
import org.cloudfoundry.client.v2.events.EventEntity;
import org.cloudfoundry.client.v2.events.EventResource;
import org.cloudfoundry.client.v2.events.ListEventsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationPrivateDomainsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainEntity;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;
import org.cloudfoundry.client.v2.routes.CreateRouteRequest;
import org.cloudfoundry.client.v2.routes.CreateRouteResponse;
import org.cloudfoundry.client.v2.routes.DeleteRouteRequest;
import org.cloudfoundry.client.v2.routes.DeleteRouteResponse;
import org.cloudfoundry.client.v2.routes.ListRoutesRequest;
import org.cloudfoundry.client.v2.routes.RouteEntity;
import org.cloudfoundry.client.v2.routes.RouteResource;
import org.cloudfoundry.client.v2.servicebindings.CreateServiceBindingRequest;
import org.cloudfoundry.client.v2.servicebindings.CreateServiceBindingResponse;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingResource;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstance;
import org.cloudfoundry.client.v2.serviceinstances.UnionServiceInstanceResource;
import org.cloudfoundry.client.v2.shareddomains.ListSharedDomainsRequest;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainEntity;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainResource;
import org.cloudfoundry.client.v2.spaces.GetSpaceRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceResponse;
import org.cloudfoundry.client.v2.spaces.GetSpaceSummaryRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceSummaryResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceApplicationsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceServiceInstancesRequest;
import org.cloudfoundry.client.v2.spaces.SpaceApplicationSummary;
import org.cloudfoundry.client.v2.spaces.SpaceEntity;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.client.v2.stacks.GetStackRequest;
import org.cloudfoundry.client.v2.stacks.GetStackResponse;
import org.cloudfoundry.client.v2.stacks.ListStacksRequest;
import org.cloudfoundry.client.v2.stacks.StackResource;
import org.cloudfoundry.client.v3.BuildpackData;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.LifecycleData;
import org.cloudfoundry.client.v3.LifecycleType;
import org.cloudfoundry.client.v3.applications.ApplicationResource;
import org.cloudfoundry.client.v3.applications.GetApplicationResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationsRequest;
import org.cloudfoundry.client.v3.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v3.tasks.CancelTaskRequest;
import org.cloudfoundry.client.v3.tasks.CancelTaskResponse;
import org.cloudfoundry.client.v3.tasks.CreateTaskRequest;
import org.cloudfoundry.client.v3.tasks.CreateTaskResponse;
import org.cloudfoundry.client.v3.tasks.TaskResource;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.doppler.Envelope;
import org.cloudfoundry.doppler.EventType;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.doppler.RecentLogsRequest;
import org.cloudfoundry.doppler.StreamRequest;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationEnvironments;
import org.cloudfoundry.operations.applications.ApplicationEvent;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.ApplicationSshEnabledRequest;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.applications.Applications;
import org.cloudfoundry.operations.applications.CopySourceApplicationRequest;
import org.cloudfoundry.operations.applications.DecomposedRoute;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.DisableApplicationSshRequest;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.DomainSummary;
import org.cloudfoundry.operations.applications.EnableApplicationSshRequest;
import org.cloudfoundry.operations.applications.GetApplicationEnvironmentsRequest;
import org.cloudfoundry.operations.applications.GetApplicationEventsRequest;
import org.cloudfoundry.operations.applications.GetApplicationHealthCheckRequest;
import org.cloudfoundry.operations.applications.GetApplicationManifestRequest;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.cloudfoundry.operations.applications.ListApplicationTasksRequest;
import org.cloudfoundry.operations.applications.LogsRequest;
import org.cloudfoundry.operations.applications.PushApplicationManifestRequest;
import org.cloudfoundry.operations.applications.PushApplicationRequest;
import org.cloudfoundry.operations.applications.RandomWords;
import org.cloudfoundry.operations.applications.RenameApplicationRequest;
import org.cloudfoundry.operations.applications.RestageApplicationRequest;
import org.cloudfoundry.operations.applications.RestartApplicationInstanceRequest;
import org.cloudfoundry.operations.applications.RestartApplicationRequest;
import org.cloudfoundry.operations.applications.Route;
import org.cloudfoundry.operations.applications.RouteUtils;
import org.cloudfoundry.operations.applications.RunApplicationTaskRequest;
import org.cloudfoundry.operations.applications.ScaleApplicationRequest;
import org.cloudfoundry.operations.applications.SetApplicationHealthCheckRequest;
import org.cloudfoundry.operations.applications.SetEnvironmentVariableApplicationRequest;
import org.cloudfoundry.operations.applications.StartApplicationRequest;
import org.cloudfoundry.operations.applications.StopApplicationRequest;
import org.cloudfoundry.operations.applications.Task;
import org.cloudfoundry.operations.applications.TaskState;
import org.cloudfoundry.operations.applications.TerminateApplicationTaskRequest;
import org.cloudfoundry.operations.applications.UnsetEnvironmentVariableApplicationRequest;
import org.cloudfoundry.operations.applications.WordListRandomWords;
import org.cloudfoundry.operations.util.OperationsLogging;
import org.cloudfoundry.util.DateUtils;
import org.cloudfoundry.util.DelayTimeoutException;
import org.cloudfoundry.util.DelayUtils;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.FileUtils;
import org.cloudfoundry.util.FluentMap;
import org.cloudfoundry.util.JobUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceMatchingUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.SortingUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple5;
import reactor.util.function.Tuples;

public final class DefaultApplications
implements Applications {
    private static final int CF_APP_STOPPED_STATS_ERROR = 200003;
    private static final int CF_BUILDPACK_COMPILED_FAILED = 170004;
    private static final int CF_INSTANCES_ERROR = 220001;
    private static final int CF_SERVICE_ALREADY_BOUND = 90003;
    private static final int CF_STAGING_ERROR = 170001;
    private static final int CF_STAGING_NOT_FINISHED = 170002;
    private static final int CF_STAGING_TIME_EXPIRED = 170007;
    private static final String[] ENTRY_FIELDS_CRASH = new String[]{"index", "reason", "exit_description"};
    private static final String[] ENTRY_FIELDS_NORMAL = new String[]{"instances", "memory", "state", "environment_json"};
    private static final Comparator<LogMessage> LOG_MESSAGE_COMPARATOR = Comparator.comparing(LogMessage::getTimestamp);
    private static final Duration LOG_MESSAGE_TIMESPAN = Duration.ofMillis(500L);
    private static final int MAX_NUMBER_OF_RECENT_EVENTS = 50;
    private static final String STARTED_STATE = "STARTED";
    private static final String STOPPED_STATE = "STOPPED";
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<DopplerClient> dopplerClient;
    private final RandomWords randomWords;
    private final Mono<String> spaceId;

    public DefaultApplications(Mono<CloudFoundryClient> cloudFoundryClient, Mono<DopplerClient> dopplerClient, Mono<String> spaceId) {
        this(cloudFoundryClient, dopplerClient, new WordListRandomWords(), spaceId);
    }

    DefaultApplications(Mono<CloudFoundryClient> cloudFoundryClient, Mono<DopplerClient> dopplerClient, RandomWords randomWords, Mono<String> spaceId) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.dopplerClient = dopplerClient;
        this.randomWords = randomWords;
        this.spaceId = spaceId;
    }

    @Override
    public Mono<Void> copySource(CopySourceApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId), DefaultApplications.getApplicationIdFromOrgSpace(cloudFoundryClient, request.getTargetName(), spaceId, request.getTargetOrganization(), request.getTargetSpace())))).flatMap(TupleUtils.function((cloudFoundryClient, sourceApplicationId, targetApplicationId) -> DefaultApplications.copyBits(cloudFoundryClient, request.getStagingTimeout(), sourceApplicationId, targetApplicationId).thenReturn((Object)Tuples.of((Object)cloudFoundryClient, (Object)targetApplicationId)))).filter(TupleUtils.predicate((cloudFoundryClient, targetApplicationId) -> Optional.ofNullable(request.getRestart()).orElse(false))).flatMap(TupleUtils.function((cloudFoundryClient, targetApplicationId) -> DefaultApplications.restartApplication(cloudFoundryClient, request.getTargetName(), targetApplicationId, request.getStagingTimeout(), request.getStartupTimeout()))).transform(OperationsLogging.log("Copy Application Source")).checkpoint();
    }

    @Override
    public Mono<Void> delete(DeleteApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultApplications.getRoutesAndApplicationId(cloudFoundryClient, request, spaceId, Optional.ofNullable(request.getDeleteRoutes()).orElse(false)).map(TupleUtils.function((routes, applicationId) -> Tuples.of((Object)cloudFoundryClient, (Object)routes, (Object)applicationId))))).flatMap(TupleUtils.function((cloudFoundryClient, routes, applicationId) -> DefaultApplications.deleteRoutes(cloudFoundryClient, request.getCompletionTimeout(), routes).thenReturn((Object)Tuples.of((Object)cloudFoundryClient, (Object)applicationId)))).delayUntil(TupleUtils.function(DefaultApplications::removeServiceBindings)).flatMap(TupleUtils.function(DefaultApplications::requestDeleteApplication)).transform(OperationsLogging.log("Delete Application")).checkpoint();
    }

    @Override
    public Mono<Void> disableSsh(DisableApplicationSshRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdWhere(cloudFoundryClient, request.getName(), spaceId, DefaultApplications.sshEnabled(true))))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestUpdateApplicationSsh(cloudFoundryClient, applicationId, false))).then().transform(OperationsLogging.log("Disable Application SSH")).checkpoint();
    }

    @Override
    public Mono<Void> enableSsh(EnableApplicationSshRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdWhere(cloudFoundryClient, request.getName(), spaceId, DefaultApplications.sshEnabled(false))))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestUpdateApplicationSsh(cloudFoundryClient, applicationId, true))).then().transform(OperationsLogging.log("Enable Application SSH")).checkpoint();
    }

    @Override
    public Mono<ApplicationDetail> get(GetApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function(DefaultApplications::getAuxiliaryContent)).map(TupleUtils.function(DefaultApplications::toApplicationDetail)).transform(OperationsLogging.log("Get Application")).checkpoint();
    }

    @Override
    public Mono<ApplicationManifest> getApplicationManifest(GetApplicationManifestRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)applicationId), DefaultApplications.requestApplicationSummary(cloudFoundryClient, applicationId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId, response) -> Mono.zip(DefaultApplications.getApplicationBuildpacks(cloudFoundryClient, applicationId), (Mono)Mono.just((Object)response), DefaultApplications.getStackName(cloudFoundryClient, response.getStackId())))).flatMap(TupleUtils.function(DefaultApplications::toApplicationManifest)).transform(OperationsLogging.log("Get Application Manifest")).checkpoint();
    }

    @Override
    public Mono<ApplicationEnvironments> getEnvironments(GetApplicationEnvironmentsRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function(DefaultApplications::requestApplicationEnvironment)).map(DefaultApplications::toApplicationEnvironments).transform(OperationsLogging.log("Get Application Environments")).checkpoint();
    }

    @Override
    public Flux<ApplicationEvent> getEvents(GetApplicationEventsRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMapMany(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestEvents(applicationId, cloudFoundryClient).take((long)Optional.ofNullable(request.getMaxNumberOfEvents()).orElse(50).intValue()))).map(DefaultApplications::convertToApplicationEvent).transform(OperationsLogging.log("Get Application Events")).checkpoint();
    }

    @Override
    public Mono<ApplicationHealthCheck> getHealthCheck(GetApplicationHealthCheckRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId))).map(DefaultApplications::toHealthCheck).transform(OperationsLogging.log("Get Application Health Check")).checkpoint();
    }

    @Override
    public Flux<ApplicationSummary> list() {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function(DefaultApplications::requestSpaceSummary)).flatMapMany(DefaultApplications::extractApplications).map(DefaultApplications::toApplicationSummary).transform(OperationsLogging.log("List Applications")).checkpoint();
    }

    @Override
    public Flux<Task> listTasks(ListApplicationTasksRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdV3(cloudFoundryClient, request.getName(), spaceId)))).flatMapMany(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestListTasks(cloudFoundryClient, applicationId))).map(DefaultApplications::toTask).transform(OperationsLogging.log("List Application Tasks")).checkpoint();
    }

    @Override
    public Flux<LogMessage> logs(LogsRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId))).flatMapMany(applicationId -> DefaultApplications.getLogs(this.dopplerClient, applicationId, request.getRecent())).transform(OperationsLogging.log("Get Application Logs")).checkpoint();
    }

    @Override
    public Mono<Void> push(PushApplicationRequest request) {
        ApplicationManifest.Builder builder = ApplicationManifest.builder().buildpacks(request.getBuildpacks()).command(request.getCommand()).disk(request.getDiskQuota()).docker(Docker.builder().image(request.getDockerImage()).password(request.getDockerPassword()).username(request.getDockerUsername()).build()).healthCheckHttpEndpoint(request.getHealthCheckHttpEndpoint()).healthCheckType(request.getHealthCheckType()).instances(request.getInstances()).memory(request.getMemory()).name(request.getName()).noHostname(request.getNoHostname()).noRoute(request.getNoRoute()).path(Optional.ofNullable(request.getPath()).orElse(request.getApplication())).randomRoute(request.getRandomRoute()).routePath(request.getRoutePath()).stack(request.getStack()).timeout(request.getTimeout());
        Optional.ofNullable(request.getDomain()).ifPresent(builder::domain);
        Optional.ofNullable(request.getHost()).ifPresent(builder::host);
        return this.pushManifest(PushApplicationManifestRequest.builder().manifest(builder.build()).dockerPassword(request.getDockerPassword()).dockerUsername(request.getDockerUsername()).noStart(request.getNoStart()).stagingTimeout(request.getStagingTimeout()).startupTimeout(request.getStartupTimeout()).build()).transform(OperationsLogging.log("Push")).checkpoint();
    }

    @Override
    public Mono<Void> pushManifest(PushApplicationManifestRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getSpaceOrganizationId(cloudFoundryClient, spaceId), (Mono)Mono.just((Object)spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, organizationId, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.listAvailableDomains(cloudFoundryClient, organizationId), (Mono)Mono.just((Object)spaceId)))).flatMapMany(TupleUtils.function((cloudFoundryClient, availableDomains, spaceId) -> Flux.fromIterable(request.getManifests()).flatMap(manifest -> {
            if (manifest.getPath() != null) {
                return DefaultApplications.pushApplication(cloudFoundryClient, availableDomains, manifest, this.randomWords, request, spaceId);
            }
            if (!manifest.getDocker().getImage().isEmpty()) {
                return DefaultApplications.pushDocker(cloudFoundryClient, availableDomains, manifest, this.randomWords, request, spaceId);
            }
            throw new IllegalStateException("One of application or dockerImage must be supplied");
        }))).then().transform(OperationsLogging.log("Push Manifest")).checkpoint();
    }

    @Override
    public Mono<Void> rename(RenameApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestUpdateApplicationName(cloudFoundryClient, applicationId, request.getNewName()))).then().transform(OperationsLogging.log("Rename Application")).checkpoint();
    }

    @Override
    public Mono<Void> restage(RestageApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.restageApplication(cloudFoundryClient, request.getName(), applicationId, request.getStagingTimeout(), request.getStartupTimeout()))).transform(OperationsLogging.log("Restage Application")).checkpoint();
    }

    @Override
    public Mono<Void> restart(RestartApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, resource) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.stopApplicationIfNotStopped(cloudFoundryClient, resource)))).flatMap(TupleUtils.function((cloudFoundryClient, stoppedApplication) -> DefaultApplications.startApplicationAndWait(cloudFoundryClient, request.getName(), ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)stoppedApplication), request.getStagingTimeout(), request.getStartupTimeout()))).transform(OperationsLogging.log("Restart Application")).checkpoint();
    }

    @Override
    public Mono<Void> restartInstance(RestartApplicationInstanceRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestTerminateApplicationInstance(cloudFoundryClient, applicationId, String.valueOf(request.getInstanceIndex())))).transform(OperationsLogging.log("Restart Application Instance")).checkpoint();
    }

    @Override
    public Mono<Task> runTask(RunApplicationTaskRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdV3(cloudFoundryClient, request.getApplicationName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestCreateTask(cloudFoundryClient, applicationId, request))).map(DefaultApplications::toTask).transform(OperationsLogging.log("Run Application Task Instance")).checkpoint();
    }

    @Override
    public Mono<Void> scale(ScaleApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).filter(TupleUtils.predicate((cloudFoundryClient, spaceId) -> DefaultApplications.areModifiersPresent(request))).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.requestUpdateApplicationScale(cloudFoundryClient, applicationId, request.getDiskLimit(), request.getInstances(), request.getMemoryLimit())))).filter(TupleUtils.predicate((cloudFoundryClient, resource) -> DefaultApplications.isRestartRequired(request, resource))).flatMap(TupleUtils.function((cloudFoundryClient, resource) -> DefaultApplications.restartApplication(cloudFoundryClient, request.getName(), ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource), request.getStagingTimeout(), request.getStartupTimeout()))).transform(OperationsLogging.log("Scale Application")).checkpoint();
    }

    @Override
    public Mono<Void> setEnvironmentVariable(SetEnvironmentVariableApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, resource) -> DefaultApplications.requestUpdateApplicationEnvironment(cloudFoundryClient, ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource), DefaultApplications.addToEnvironment(DefaultApplications.getEnvironment(resource), request.getVariableName(), request.getVariableValue())))).then().transform(OperationsLogging.log("Set Application Environment Variable")).checkpoint();
    }

    @Override
    public Mono<Void> setHealthCheck(SetApplicationHealthCheckRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestUpdateApplicationHealthCheckType(cloudFoundryClient, applicationId, request.getType()))).then().transform(OperationsLogging.log("Set Application Health Check")).checkpoint();
    }

    @Override
    public Mono<Boolean> sshEnabled(ApplicationSshEnabledRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId))).map(applicationResource -> ((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)applicationResource)).getEnableSsh()).transform(OperationsLogging.log("Is Application SSH Enabled")).checkpoint();
    }

    @Override
    public Mono<Void> start(StartApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdWhere(cloudFoundryClient, request.getName(), spaceId, DefaultApplications.isNotIn(STARTED_STATE))))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.startApplicationAndWait(cloudFoundryClient, request.getName(), applicationId, request.getStagingTimeout(), request.getStartupTimeout()))).transform(OperationsLogging.log("Start Application")).checkpoint();
    }

    @Override
    public Mono<Void> stop(StopApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdWhere(cloudFoundryClient, request.getName(), spaceId, DefaultApplications.isNotIn(STOPPED_STATE))))).flatMap(TupleUtils.function(DefaultApplications::stopApplication)).then().transform(OperationsLogging.log("Stop Application")).checkpoint();
    }

    @Override
    public Mono<Void> terminateTask(TerminateApplicationTaskRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdV3(cloudFoundryClient, request.getApplicationName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getTaskId(cloudFoundryClient, applicationId, request.getSequenceId())))).flatMap(TupleUtils.function(DefaultApplications::requestTerminateTask)).then().transform(OperationsLogging.log("Terminate Application Task Instance")).checkpoint();
    }

    @Override
    public Mono<Void> unsetEnvironmentVariable(UnsetEnvironmentVariableApplicationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, resource) -> DefaultApplications.requestUpdateApplicationEnvironment(cloudFoundryClient, ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource), DefaultApplications.removeFromEnvironment(DefaultApplications.getEnvironment(resource), request.getVariableName())))).then().transform(OperationsLogging.log("Unset Application Environment Variable")).checkpoint();
    }

    private static Map<String, Object> addToEnvironment(Map<String, Object> environment, String variableName, Object variableValue) {
        return FluentMap.builder().entries(environment).entry((Object)variableName, variableValue).build();
    }

    private static boolean areModifiersPresent(ScaleApplicationRequest request) {
        return request.getMemoryLimit() != null || request.getDiskLimit() != null || request.getInstances() != null;
    }

    private static Flux<String> associateDefaultDomain(CloudFoundryClient cloudFoundryClient, String applicationId, List<DomainSummary> availableDomains, ApplicationManifest manifest, RandomWords randomWords, String spaceId) {
        return DefaultApplications.getDefaultDomainId(cloudFoundryClient).flatMapMany(domainId -> DefaultApplications.getPushRouteIdFromDomain(cloudFoundryClient, availableDomains, domainId, manifest, randomWords, spaceId)).flatMap(routeId -> DefaultApplications.requestAssociateRoute(cloudFoundryClient, applicationId, routeId)).map(ResourceUtils::getId);
    }

    private static Mono<Void> bindServices(CloudFoundryClient cloudFoundryClient, String applicationId, ApplicationManifest manifest, String spaceId) {
        if (manifest.getServices() == null || manifest.getServices().size() == 0) {
            return Mono.empty();
        }
        return Flux.fromIterable(manifest.getServices()).flatMap(serviceInstanceName -> DefaultApplications.getServiceId(cloudFoundryClient, serviceInstanceName, spaceId)).flatMap(serviceInstanceId -> DefaultApplications.requestCreateServiceBinding(cloudFoundryClient, applicationId, serviceInstanceId).onErrorResume(ExceptionUtils.statusCode((int[])new int[]{90003}), t -> Mono.empty())).then();
    }

    private static String cleanName(ApplicationManifest manifest) {
        return manifest.getName().replaceAll("\\.", "");
    }

    private static BiFunction<String, String, String> collectStates() {
        return (totalState, instanceState) -> {
            if ("RUNNING".equals(instanceState) || "RUNNING".equals(totalState)) {
                return "RUNNING";
            }
            if ("FLAPPING".equals(instanceState) || "CRASHED".equals(instanceState)) {
                return "FAILED";
            }
            return totalState;
        };
    }

    private static ApplicationEvent convertToApplicationEvent(EventResource resource) {
        EventEntity entity = resource.getEntity();
        Date timestamp = null;
        try {
            timestamp = DateUtils.parseFromIso8601((String)entity.getTimestamp());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ApplicationEvent.builder().actor(entity.getActorName()).description(DefaultApplications.eventDescription(DefaultApplications.getMetadataRequest(entity), DefaultApplications.getEntryNames(entity.getType()))).id(ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource)).event(entity.getType()).time(timestamp).build();
    }

    private static Mono<Void> copyBits(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, String sourceApplicationId, String targetApplicationId) {
        return DefaultApplications.requestCopyBits(cloudFoundryClient, sourceApplicationId, targetApplicationId).flatMap(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)completionTimeout, (org.cloudfoundry.client.v2.Resource)job));
    }

    private static Mono<Void> deleteRoute(CloudFoundryClient cloudFoundryClient, String routeId, Duration completionTimeout) {
        return DefaultApplications.requestDeleteRoute(cloudFoundryClient, routeId).flatMap(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)completionTimeout, (org.cloudfoundry.client.v2.Resource)job));
    }

    private static Mono<Void> deleteRoutes(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, Optional<List<org.cloudfoundry.client.v2.routes.Route>> routes) {
        return routes.map(Flux::fromIterable).orElse(Flux.empty()).map(org.cloudfoundry.client.v2.routes.Route::getId).flatMap(routeId -> DefaultApplications.deleteRoute(cloudFoundryClient, routeId, completionTimeout)).then();
    }

    private static String deriveHostname(String host, ApplicationManifest manifest, RandomWords randomWords) {
        if (Optional.ofNullable(manifest.getNoHostname()).orElse(false).booleanValue()) {
            return "";
        }
        if (host != null) {
            return host;
        }
        if (Optional.ofNullable(manifest.getRandomRoute()).orElse(false).booleanValue()) {
            return String.join((CharSequence)"-", DefaultApplications.cleanName(manifest), randomWords.getAdjective(), randomWords.getNoun());
        }
        return DefaultApplications.cleanName(manifest);
    }

    private static Statistics emptyApplicationStatistics() {
        return Statistics.builder().usage(DefaultApplications.emptyApplicationUsage()).build();
    }

    private static Usage emptyApplicationUsage() {
        return Usage.builder().build();
    }

    private static InstanceStatistics emptyInstanceStats() {
        return InstanceStatistics.builder().statistics(DefaultApplications.emptyApplicationStatistics()).build();
    }

    private static String eventDescription(Map<String, Object> request, String ... entryNames) {
        if (request == null) {
            return "";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String entryName : entryNames) {
            Object value = request.get(entryName);
            if (value == null) continue;
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(entryName).append(": ").append(String.valueOf(value));
        }
        return sb.toString();
    }

    private static Flux<SpaceApplicationSummary> extractApplications(GetSpaceSummaryResponse getSpaceSummaryResponse) {
        return Flux.fromIterable((Iterable)getSpaceSummaryResponse.getApplications());
    }

    private static Mono<AbstractApplicationResource> getApplication(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return DefaultApplications.requestApplications(cloudFoundryClient, application, spaceId).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Application %s does not exist", (Object[])new Object[]{application}));
    }

    private static Mono<List<String>> getApplicationBuildpacks(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV3().get(org.cloudfoundry.client.v3.applications.GetApplicationRequest.builder().applicationId(applicationId).build()).map(GetApplicationResponse::getLifecycle).filter(lifecycle -> LifecycleType.BUILDPACK == lifecycle.getType()).map(Lifecycle::getData).cast(BuildpackData.class).map(BuildpackData::getBuildpacks).defaultIfEmpty(Collections.emptyList());
    }

    private static Mono<String> getApplicationId(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return DefaultApplications.getApplication(cloudFoundryClient, application, spaceId).map(ResourceUtils::getId);
    }

    private static Mono<String> getApplicationId(CloudFoundryClient cloudFoundryClient, ApplicationManifest manifest, String spaceId, String stackId) {
        return DefaultApplications.requestApplications(cloudFoundryClient, manifest.getName(), spaceId).singleOrEmpty().flatMap(application -> {
            HashMap<String, Object> merge = new HashMap<String, Object>();
            Optional.ofNullable(((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)application)).getEnvironmentJsons()).ifPresent(merge::putAll);
            Optional.ofNullable(manifest.getEnvironmentVariables()).ifPresent(merge::putAll);
            return DefaultApplications.requestUpdateApplication(cloudFoundryClient, ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)application), merge, manifest, stackId).map(ResourceUtils::getId);
        }).switchIfEmpty(DefaultApplications.requestCreateApplication(cloudFoundryClient, manifest, spaceId, stackId).map(ResourceUtils::getId));
    }

    private static Mono<String> getApplicationIdFromOrgSpace(CloudFoundryClient cloudFoundryClient, String application, String spaceId, String organization, String space) {
        return DefaultApplications.getSpaceOrganizationId(cloudFoundryClient, spaceId).flatMap(organizationId -> organization != null ? DefaultApplications.getOrganizationId(cloudFoundryClient, organization) : Mono.just((Object)organizationId)).flatMap(organizationId -> space != null ? DefaultApplications.getSpaceId(cloudFoundryClient, organizationId, space) : Mono.just((Object)spaceId)).flatMap(spaceId1 -> DefaultApplications.getApplicationId(cloudFoundryClient, application, spaceId1));
    }

    private static Mono<String> getApplicationIdV3(CloudFoundryClient cloudFoundryClient, String applicationName, String spaceId) {
        return DefaultApplications.getApplicationV3(cloudFoundryClient, applicationName, spaceId).map(ApplicationResource::getId);
    }

    private static Mono<String> getApplicationIdWhere(CloudFoundryClient cloudFoundryClient, String application, String spaceId, Predicate<AbstractApplicationResource> predicate) {
        return DefaultApplications.getApplication(cloudFoundryClient, application, spaceId).filter(predicate).map(ResourceUtils::getId);
    }

    private static Mono<ApplicationInstancesResponse> getApplicationInstances(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestApplicationInstances(cloudFoundryClient, applicationId).onErrorResume(ExceptionUtils.statusCode((int[])new int[]{170004, 220001, 170002, 170007, 170001}), t -> Mono.just((Object)ApplicationInstancesResponse.builder().build()));
    }

    private static Mono<List<RouteResource>> getApplicationRoutes(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestApplicationRoutes(cloudFoundryClient, applicationId).collectList();
    }

    private static Mono<ApplicationStatisticsResponse> getApplicationStatistics(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestApplicationStatistics(cloudFoundryClient, applicationId).onErrorResume(ExceptionUtils.statusCode((int[])new int[]{200003}), t -> Mono.just((Object)ApplicationStatisticsResponse.builder().build()));
    }

    private static Mono<ApplicationResource> getApplicationV3(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return DefaultApplications.requestApplicationsV3(cloudFoundryClient, application, spaceId).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Application %s does not exist", (Object[])new Object[]{application}));
    }

    private static Mono<Tuple5<List<String>, SummaryApplicationResponse, GetStackResponse, List<InstanceDetail>, List<String>>> getAuxiliaryContent(CloudFoundryClient cloudFoundryClient, AbstractApplicationResource applicationResource) {
        String applicationId = ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)applicationResource);
        String stackId = ((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)applicationResource)).getStackId();
        return Mono.zip(DefaultApplications.getApplicationStatistics(cloudFoundryClient, applicationId), DefaultApplications.requestApplicationSummary(cloudFoundryClient, applicationId), DefaultApplications.getApplicationInstances(cloudFoundryClient, applicationId)).flatMap(TupleUtils.function((applicationStatisticsResponse, summaryApplicationResponse, applicationInstancesResponse) -> Mono.zip(DefaultApplications.getApplicationBuildpacks(cloudFoundryClient, applicationId), (Mono)Mono.just((Object)summaryApplicationResponse), DefaultApplications.requestStack(cloudFoundryClient, stackId), DefaultApplications.toInstanceDetailList(applicationInstancesResponse, applicationStatisticsResponse), DefaultApplications.toUrls(summaryApplicationResponse.getRoutes()))));
    }

    private static Mono<String> getDefaultDomainId(CloudFoundryClient cloudFoundryClient) {
        return DefaultApplications.requestSharedDomains(cloudFoundryClient).filter(resource -> Optional.ofNullable(((SharedDomainEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getInternal()).orElse(false) == false).map(ResourceUtils::getId).next().switchIfEmpty(ExceptionUtils.illegalArgument((String)"No default domain found", (Object[])new Object[0]));
    }

    private static String getDomainId(List<DomainSummary> availableDomains, String domainName) {
        return availableDomains.stream().filter(domain -> domainName.equals(domain.getName())).map(DomainSummary::getId).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Domain %s not found", domainName)));
    }

    private static String[] getEntryNames(String type) {
        return type.contains("crash") ? ENTRY_FIELDS_CRASH : ENTRY_FIELDS_NORMAL;
    }

    private static Map<String, Object> getEnvironment(AbstractApplicationResource resource) {
        return ((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getEnvironmentJsons();
    }

    private static int getInstances(AbstractApplicationResource resource) {
        return Optional.ofNullable(resource.getEntity()).map(ApplicationEntity::getInstances).orElse(0);
    }

    private static Flux<LogMessage> getLogs(Mono<DopplerClient> dopplerClient, String applicationId, Boolean recent) {
        if (Optional.ofNullable(recent).orElse(false).booleanValue()) {
            return DefaultApplications.requestLogsRecent(dopplerClient, applicationId).filter(e -> EventType.LOG_MESSAGE == e.getEventType()).map(Envelope::getLogMessage).collectSortedList(LOG_MESSAGE_COMPARATOR).flatMapIterable(d -> d);
        }
        return DefaultApplications.requestLogsStream(dopplerClient, applicationId).filter(e -> EventType.LOG_MESSAGE == e.getEventType()).map(Envelope::getLogMessage).transformDeferred(SortingUtils.timespan(LOG_MESSAGE_COMPARATOR, (Duration)LOG_MESSAGE_TIMESPAN));
    }

    private static Map<String, Object> getMetadataRequest(EventEntity entity) {
        Map metadata = Optional.ofNullable(entity.getMetadatas()).orElse(Collections.emptyMap());
        if (metadata.get("request") != null) {
            return ((Optional)metadata.get("request")).map(m -> (Map)m).orElse(Collections.emptyMap());
        }
        if (metadata.get("instance") != null) {
            return metadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((Optional)v.getValue()).orElse("")));
        }
        return Collections.emptyMap();
    }

    private static Mono<Optional<List<org.cloudfoundry.client.v2.routes.Route>>> getOptionalRoutes(CloudFoundryClient cloudFoundryClient, boolean deleteRoutes, String applicationId) {
        if (deleteRoutes) {
            return DefaultApplications.getRoutes(cloudFoundryClient, applicationId).map(Optional::of);
        }
        return Mono.just(Optional.empty());
    }

    private static Mono<Optional<String>> getOptionalStackId(CloudFoundryClient cloudFoundryClient, String stack) {
        return Optional.ofNullable(stack).map(stack1 -> DefaultApplications.getStackId(cloudFoundryClient, stack1).map(Optional::of)).orElse(Mono.just(Optional.empty()));
    }

    private static Mono<OrganizationResource> getOrganization(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultApplications.requestOrganizations(cloudFoundryClient, organization).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Organization %s not found", (Object[])new Object[]{organization}));
    }

    private static Mono<String> getOrganizationId(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultApplications.getOrganization(cloudFoundryClient, organization).map(ResourceUtils::getId);
    }

    private static Mono<SpaceResource> getOrganizationSpaceByName(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return DefaultApplications.requestOrganizationSpacesByName(cloudFoundryClient, organizationId, space).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Space %s not found", (Object[])new Object[]{space}));
    }

    private static String getPassword(DockerCredentials dockerCredentials) {
        return Optional.ofNullable(dockerCredentials).map(DockerCredentials::getPassword).orElse(null);
    }

    private static Flux<String> getPushRouteIdFromDomain(CloudFoundryClient cloudFoundryClient, List<DomainSummary> availableDomains, String domainId, ApplicationManifest manifest, RandomWords randomWords, String spaceId) {
        if (DefaultApplications.isTcpDomain(availableDomains, domainId)) {
            return DefaultApplications.requestCreateTcpRoute(cloudFoundryClient, domainId, spaceId).map(ResourceUtils::getId).flux();
        }
        List<String> hosts = Optional.ofNullable(manifest.getNoHostname()).orElse(false) != false ? Collections.singletonList("") : (Optional.ofNullable(manifest.getRandomRoute()).orElse(false) != false && manifest.getHosts() == null ? Collections.singletonList(String.join((CharSequence)"-", DefaultApplications.cleanName(manifest), randomWords.getAdjective(), randomWords.getNoun())) : (manifest.getHosts() == null || manifest.getHosts().isEmpty() ? Collections.singletonList(DefaultApplications.cleanName(manifest)) : manifest.getHosts()));
        return Flux.fromIterable(hosts).flatMap(host -> DefaultApplications.getRouteId(cloudFoundryClient, domainId, host, manifest.getRoutePath()).switchIfEmpty(DefaultApplications.requestCreateRoute(cloudFoundryClient, domainId, host, manifest.getRoutePath(), spaceId).map(ResourceUtils::getId)));
    }

    private static Flux<String> getPushRouteIdFromRoute(CloudFoundryClient cloudFoundryClient, List<DomainSummary> availableDomains, ApplicationManifest manifest, RandomWords randomWords, String spaceId) {
        return Flux.fromIterable(manifest.getRoutes()).flatMap(route -> RouteUtils.decomposeRoute(availableDomains, route.getRoute(), manifest.getRoutePath())).flatMap(decomposedRoute -> {
            String domainId = DefaultApplications.getDomainId(availableDomains, decomposedRoute.getDomain());
            if (DefaultApplications.isTcpDomain(availableDomains, domainId)) {
                return DefaultApplications.getRouteIdForTcpRoute(cloudFoundryClient, decomposedRoute, domainId, manifest, spaceId);
            }
            return DefaultApplications.getRouteIdForHttpRoute(cloudFoundryClient, decomposedRoute, domainId, manifest, randomWords, spaceId);
        });
    }

    private static Mono<String> getRouteId(CloudFoundryClient cloudFoundryClient, String domainId, String host, String routePath) {
        return DefaultApplications.requestRoutes(cloudFoundryClient, domainId, host, null, routePath).filter(resource -> DefaultApplications.isIdentical(host, ((RouteEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getHost())).filter(resource -> DefaultApplications.isIdentical(Optional.ofNullable(routePath).orElse(""), ((RouteEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getPath())).singleOrEmpty().map(ResourceUtils::getId);
    }

    private static Mono<String> getRouteIdForHttpRoute(CloudFoundryClient cloudFoundryClient, DecomposedRoute decomposedRoute, String domainId, ApplicationManifest manifest, RandomWords randomWords, String spaceId) {
        String derivedHost = DefaultApplications.deriveHostname(decomposedRoute.getHost(), manifest, randomWords);
        return DefaultApplications.getRouteId(cloudFoundryClient, domainId, derivedHost, decomposedRoute.getPath()).switchIfEmpty(DefaultApplications.requestCreateRoute(cloudFoundryClient, domainId, derivedHost, decomposedRoute.getPath(), spaceId).map(ResourceUtils::getId));
    }

    private static Mono<String> getRouteIdForTcpRoute(CloudFoundryClient cloudFoundryClient, DecomposedRoute decomposedRoute, String domainId, ApplicationManifest manifest, String spaceId) {
        if (Optional.ofNullable(manifest.getRandomRoute()).orElse(false).booleanValue()) {
            return DefaultApplications.requestCreateTcpRoute(cloudFoundryClient, domainId, spaceId).map(ResourceUtils::getId);
        }
        return DefaultApplications.getTcpRouteId(cloudFoundryClient, domainId, decomposedRoute.getPort()).switchIfEmpty(DefaultApplications.requestCreateTcpRoute(cloudFoundryClient, domainId, decomposedRoute.getPort(), spaceId).map(ResourceUtils::getId));
    }

    private static Mono<List<org.cloudfoundry.client.v2.routes.Route>> getRoutes(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestApplicationSummary(cloudFoundryClient, applicationId).map(SummaryApplicationResponse::getRoutes);
    }

    private static Mono<Tuple2<Optional<List<org.cloudfoundry.client.v2.routes.Route>>, String>> getRoutesAndApplicationId(CloudFoundryClient cloudFoundryClient, DeleteApplicationRequest request, String spaceId, boolean deleteRoutes) {
        return DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId).flatMap(applicationId -> DefaultApplications.getOptionalRoutes(cloudFoundryClient, deleteRoutes, applicationId).zipWith(Mono.just((Object)applicationId)));
    }

    private static Mono<String> getServiceId(CloudFoundryClient cloudFoundryClient, String serviceInstanceName, String spaceId) {
        return DefaultApplications.requestListServiceInstances(cloudFoundryClient, serviceInstanceName, spaceId).map(ResourceUtils::getId).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Service instance %s could not be found", (Object[])new Object[]{serviceInstanceName}));
    }

    private static Mono<String> getSpaceId(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return DefaultApplications.getOrganizationSpaceByName(cloudFoundryClient, organizationId, space).map(ResourceUtils::getId);
    }

    private static Mono<String> getSpaceOrganizationId(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return DefaultApplications.requestSpace(cloudFoundryClient, spaceId).map(response -> ((SpaceEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)response)).getOrganizationId());
    }

    private static Mono<String> getStackId(CloudFoundryClient cloudFoundryClient, String stack) {
        return DefaultApplications.requestStacks(cloudFoundryClient, stack).map(ResourceUtils::getId).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Stack %s does not exist", (Object[])new Object[]{stack}));
    }

    private static Mono<String> getStackName(CloudFoundryClient cloudFoundryClient, String stackId) {
        return DefaultApplications.requestStack(cloudFoundryClient, stackId).map(getStackResponse -> getStackResponse.getEntity().getName());
    }

    private static Mono<String> getTaskId(CloudFoundryClient cloudFoundryClient, String applicationId, Integer sequenceId) {
        return DefaultApplications.listTasks(cloudFoundryClient, applicationId, sequenceId).single().map(org.cloudfoundry.client.v3.Resource::getId).onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Task with sequence id of %s does not exist", (Object[])new Object[]{sequenceId}));
    }

    private static Mono<String> getTcpRouteId(CloudFoundryClient cloudFoundryClient, String domainId, Integer port) {
        return DefaultApplications.requestRoutes(cloudFoundryClient, domainId, null, port, null).singleOrEmpty().map(ResourceUtils::getId);
    }

    private static String getUsername(DockerCredentials dockerCredentials) {
        return Optional.ofNullable(dockerCredentials).map(DockerCredentials::getUsername).orElse(null);
    }

    private static boolean isIdentical(String s, String t) {
        return Objects.equals(s, t);
    }

    private static Predicate<String> isInstanceComplete() {
        return state -> "RUNNING".equals(state) || "FAILED".equals(state);
    }

    private static Predicate<AbstractApplicationResource> isNotIn(String expectedState) {
        return resource -> DefaultApplications.isNotIn(resource, expectedState);
    }

    private static boolean isNotIn(AbstractApplicationResource resource, String expectedState) {
        return !expectedState.equals(((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getState());
    }

    private static boolean isRestartRequired(ScaleApplicationRequest request, AbstractApplicationResource applicationResource) {
        return (request.getDiskLimit() != null || request.getMemoryLimit() != null) && STARTED_STATE.equals(((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)applicationResource)).getState());
    }

    private static Predicate<String> isRunning() {
        return "RUNNING"::equals;
    }

    private static Predicate<String> isStaged() {
        return "STAGED"::equals;
    }

    private static Predicate<String> isStagingComplete() {
        return state -> "STAGED".equals(state) || "FAILED".equals(state);
    }

    private static boolean isTcpDomain(List<DomainSummary> availableDomains, String domainId) {
        List tcpDomainIds = availableDomains.stream().filter(domain -> "tcp".equals(domain.getType())).map(DomainSummary::getId).collect(Collectors.toList());
        return tcpDomainIds.contains(domainId);
    }

    private static Mono<List<DomainSummary>> listAvailableDomains(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return DefaultApplications.requestListPrivateDomains(cloudFoundryClient, organizationId).map(DefaultApplications::toDomain).mergeWith((Publisher)DefaultApplications.requestListSharedDomains(cloudFoundryClient).map(DefaultApplications::toDomain)).collectList();
    }

    private static Flux<org.cloudfoundry.client.v3.tasks.Task> listTasks(CloudFoundryClient cloudFoundryClient, String applicationId, Integer sequenceId) {
        return DefaultApplications.requestListTasks(cloudFoundryClient, applicationId, sequenceId).cast(org.cloudfoundry.client.v3.tasks.Task.class);
    }

    private static Mono<Void> prepareDomainsAndRoutes(CloudFoundryClient cloudFoundryClient, String applicationId, List<DomainSummary> availableDomains, ApplicationManifest manifest, List<RouteResource> existingRoutes, RandomWords randomWords, String spaceId) {
        if (Optional.ofNullable(manifest.getNoRoute()).orElse(false).booleanValue()) {
            return Flux.fromIterable(existingRoutes).map(ResourceUtils::getId).flatMap(routeId -> DefaultApplications.requestRemoveRouteFromApplication(cloudFoundryClient, applicationId, routeId)).then();
        }
        if (manifest.getRoutes() == null) {
            if (manifest.getDomains() == null) {
                if (existingRoutes.isEmpty()) {
                    return DefaultApplications.associateDefaultDomain(cloudFoundryClient, applicationId, availableDomains, manifest, randomWords, spaceId).then();
                }
                return Mono.empty();
            }
            return Flux.fromIterable(manifest.getDomains()).flatMap(domain -> DefaultApplications.getPushRouteIdFromDomain(cloudFoundryClient, availableDomains, DefaultApplications.getDomainId(availableDomains, domain), manifest, randomWords, spaceId).flatMap(routeId -> DefaultApplications.requestAssociateRoute(cloudFoundryClient, applicationId, routeId))).then();
        }
        List existingRouteIds = existingRoutes.stream().map(ResourceUtils::getId).collect(Collectors.toList());
        return DefaultApplications.getPushRouteIdFromRoute(cloudFoundryClient, availableDomains, manifest, randomWords, spaceId).filter(routeId -> !existingRouteIds.contains(routeId)).flatMapSequential(routeId -> DefaultApplications.requestAssociateRoute(cloudFoundryClient, applicationId, routeId), 1).then();
    }

    private static Flux<Void> pushApplication(CloudFoundryClient cloudFoundryClient, List<DomainSummary> availableDomains, ApplicationManifest manifest, RandomWords randomWords, PushApplicationManifestRequest request, String spaceId) {
        return DefaultApplications.getOptionalStackId(cloudFoundryClient, manifest.getStack()).flatMapMany(stackId -> DefaultApplications.getApplicationId(cloudFoundryClient, manifest, spaceId, stackId.orElse(null))).flatMap(applicationId -> Mono.zip((Mono)Mono.just((Object)applicationId), DefaultApplications.getApplicationRoutes(cloudFoundryClient, applicationId), (Mono)ResourceMatchingUtils.getMatchedResources((CloudFoundryClient)cloudFoundryClient, (Path)manifest.getPath()))).flatMap(TupleUtils.function((applicationId, existingRoutes, matchedResources) -> DefaultApplications.prepareDomainsAndRoutes(cloudFoundryClient, applicationId, availableDomains, manifest, existingRoutes, randomWords, spaceId).thenReturn((Object)Tuples.of((Object)applicationId, (Object)matchedResources)))).flatMap(TupleUtils.function((applicationId, matchedResources) -> Mono.when((Publisher[])new Publisher[]{DefaultApplications.bindServices(cloudFoundryClient, applicationId, manifest, spaceId), DefaultApplications.updateBuildpacks(cloudFoundryClient, applicationId, manifest), DefaultApplications.uploadApplicationAndWait(cloudFoundryClient, applicationId, manifest.getPath(), matchedResources, request.getStagingTimeout())}).thenReturn(applicationId))).flatMap(applicationId -> DefaultApplications.stopAndStartApplication(cloudFoundryClient, applicationId, manifest.getName(), request));
    }

    private static Flux<Void> pushDocker(CloudFoundryClient cloudFoundryClient, List<DomainSummary> availableDomains, ApplicationManifest manifest, RandomWords randomWords, PushApplicationManifestRequest request, String spaceId) {
        return DefaultApplications.getOptionalStackId(cloudFoundryClient, manifest.getStack()).flatMapMany(stackId -> DefaultApplications.getApplicationId(cloudFoundryClient, manifest, spaceId, stackId.orElse(null))).flatMap(applicationId -> Mono.zip((Mono)Mono.just((Object)applicationId), DefaultApplications.getApplicationRoutes(cloudFoundryClient, applicationId))).flatMap(TupleUtils.function((applicationId, existingRoutes) -> DefaultApplications.prepareDomainsAndRoutes(cloudFoundryClient, applicationId, availableDomains, manifest, existingRoutes, randomWords, spaceId).thenReturn(applicationId))).delayUntil(applicationId -> DefaultApplications.bindServices(cloudFoundryClient, applicationId, manifest, spaceId)).flatMap(applicationId -> DefaultApplications.stopAndStartApplication(cloudFoundryClient, applicationId, manifest.getName(), request));
    }

    private static Map<String, Object> removeFromEnvironment(Map<String, Object> environment, String variableName) {
        HashMap<String, Object> modified = new HashMap<String, Object>(environment);
        modified.remove(variableName);
        return modified;
    }

    private static Mono<Void> removeServiceBindings(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestListServiceBindings(cloudFoundryClient, applicationId).map(ResourceUtils::getId).flatMap(serviceBindingId -> DefaultApplications.requestRemoveServiceBinding(cloudFoundryClient, applicationId, serviceBindingId)).then();
    }

    private static Mono<ApplicationEnvironmentResponse> requestApplicationEnvironment(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().environment(ApplicationEnvironmentRequest.builder().applicationId(applicationId).build());
    }

    private static Mono<ApplicationInstancesResponse> requestApplicationInstances(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().instances(ApplicationInstancesRequest.builder().applicationId(applicationId).build());
    }

    private static Flux<RouteResource> requestApplicationRoutes(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.applicationsV2().listRoutes(ListApplicationRoutesRequest.builder().applicationId(applicationId).page(page).build()));
    }

    private static Mono<ApplicationStatisticsResponse> requestApplicationStatistics(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().statistics(ApplicationStatisticsRequest.builder().applicationId(applicationId).build());
    }

    private static Mono<SummaryApplicationResponse> requestApplicationSummary(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().summary(SummaryApplicationRequest.builder().applicationId(applicationId).build());
    }

    private static Flux<AbstractApplicationResource> requestApplications(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listApplications(ListSpaceApplicationsRequest.builder().name(application).spaceId(spaceId).page(page).build())).cast(AbstractApplicationResource.class);
    }

    private static Flux<ApplicationResource> requestApplicationsV3(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return PaginationUtils.requestClientV3Resources(page -> cloudFoundryClient.applicationsV3().list(ListApplicationsRequest.builder().name(application).spaceId(spaceId).page(page).build()));
    }

    private static Mono<AssociateApplicationRouteResponse> requestAssociateRoute(CloudFoundryClient cloudFoundryClient, String applicationId, String routeId) {
        return cloudFoundryClient.applicationsV2().associateRoute(AssociateApplicationRouteRequest.builder().applicationId(applicationId).routeId(routeId).build());
    }

    private static Mono<CopyApplicationResponse> requestCopyBits(CloudFoundryClient cloudFoundryClient, String sourceApplicationId, String targetApplicationId) {
        return cloudFoundryClient.applicationsV2().copy(CopyApplicationRequest.builder().applicationId(targetApplicationId).sourceApplicationId(sourceApplicationId).build());
    }

    private static Mono<CreateApplicationResponse> requestCreateApplication(CloudFoundryClient cloudFoundryClient, ApplicationManifest manifest, String spaceId, String stackId) {
        CreateApplicationRequest.Builder builder = CreateApplicationRequest.builder().command(manifest.getCommand()).diskQuota(manifest.getDisk()).environmentJsons(manifest.getEnvironmentVariables()).healthCheckHttpEndpoint(manifest.getHealthCheckHttpEndpoint()).healthCheckTimeout(manifest.getTimeout()).healthCheckType((String)Optional.ofNullable(manifest.getHealthCheckType()).map(ApplicationHealthCheck::getValue).orElse(null)).instances(manifest.getInstances()).memory(manifest.getMemory()).name(manifest.getName()).spaceId(spaceId).stackId(stackId);
        if (manifest.getBuildpacks() != null && manifest.getBuildpacks().size() == 1) {
            builder.buildpack(manifest.getBuildpacks().get(0));
        }
        if (manifest.getDocker() != null) {
            Optional.ofNullable(manifest.getDocker().getImage()).ifPresent(image -> {
                builder.diego(Boolean.valueOf(true)).dockerImage(image);
                String username = manifest.getDocker().getUsername();
                String password = manifest.getDocker().getPassword();
                builder.dockerCredentials(DockerCredentials.builder().username(username).password(password).build());
            });
        }
        return cloudFoundryClient.applicationsV2().create(builder.build());
    }

    private static Mono<CreateRouteResponse> requestCreateRoute(CloudFoundryClient cloudFoundryClient, String domainId, String host, String routePath, String spaceId) {
        return cloudFoundryClient.routes().create(CreateRouteRequest.builder().domainId(domainId).host(host).path(routePath).spaceId(spaceId).build());
    }

    private static Mono<CreateServiceBindingResponse> requestCreateServiceBinding(CloudFoundryClient cloudFoundryClient, String applicationId, String serviceInstanceId) {
        return cloudFoundryClient.serviceBindingsV2().create(CreateServiceBindingRequest.builder().applicationId(applicationId).serviceInstanceId(serviceInstanceId).build());
    }

    private static Mono<CreateTaskResponse> requestCreateTask(CloudFoundryClient cloudFoundryClient, String applicationId, RunApplicationTaskRequest request) {
        return cloudFoundryClient.tasks().create(CreateTaskRequest.builder().applicationId(applicationId).command(request.getCommand()).diskInMb(request.getDisk()).memoryInMb(request.getMemory()).name(request.getTaskName()).build());
    }

    private static Mono<CreateRouteResponse> requestCreateTcpRoute(CloudFoundryClient cloudFoundryClient, String domainId, String spaceId) {
        return cloudFoundryClient.routes().create(CreateRouteRequest.builder().domainId(domainId).generatePort(Boolean.valueOf(true)).spaceId(spaceId).build());
    }

    private static Mono<CreateRouteResponse> requestCreateTcpRoute(CloudFoundryClient cloudFoundryClient, String domainId, Integer port, String spaceId) {
        return cloudFoundryClient.routes().create(CreateRouteRequest.builder().domainId(domainId).port(port).spaceId(spaceId).build());
    }

    private static Mono<Void> requestDeleteApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().delete(org.cloudfoundry.client.v2.applications.DeleteApplicationRequest.builder().applicationId(applicationId).build());
    }

    private static Mono<DeleteRouteResponse> requestDeleteRoute(CloudFoundryClient cloudFoundryClient, String routeId) {
        return cloudFoundryClient.routes().delete(DeleteRouteRequest.builder().async(Boolean.valueOf(true)).routeId(routeId).build());
    }

    private static Flux<EventResource> requestEvents(String applicationId, CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.events().list(ListEventsRequest.builder().actee(applicationId).orderDirection(OrderDirection.DESCENDING).resultsPerPage(Integer.valueOf(50)).page(page).build()));
    }

    private static Mono<AbstractApplicationResource> requestGetApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().get(org.cloudfoundry.client.v2.applications.GetApplicationRequest.builder().applicationId(applicationId).build()).cast(AbstractApplicationResource.class);
    }

    private static Flux<PrivateDomainResource> requestListPrivateDomains(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listPrivateDomains(ListOrganizationPrivateDomainsRequest.builder().organizationId(organizationId).page(page).build()));
    }

    private static Flux<ServiceBindingResource> requestListServiceBindings(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.applicationsV2().listServiceBindings(ListApplicationServiceBindingsRequest.builder().applicationId(applicationId).page(page).build()));
    }

    private static Flux<UnionServiceInstanceResource> requestListServiceInstances(CloudFoundryClient cloudFoundryClient, String serviceInstanceName, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listServiceInstances(ListSpaceServiceInstancesRequest.builder().page(page).returnUserProvidedServiceInstances(Boolean.valueOf(true)).name(serviceInstanceName).spaceId(spaceId).build()));
    }

    private static Flux<SharedDomainResource> requestListSharedDomains(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().page(page).build()));
    }

    private static Flux<TaskResource> requestListTasks(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return PaginationUtils.requestClientV3Resources(page -> cloudFoundryClient.applicationsV3().listTasks(org.cloudfoundry.client.v3.applications.ListApplicationTasksRequest.builder().applicationId(applicationId).page(page).build()));
    }

    private static Flux<TaskResource> requestListTasks(CloudFoundryClient cloudFoundryClient, String applicationId, Integer sequenceId) {
        return PaginationUtils.requestClientV3Resources(page -> cloudFoundryClient.applicationsV3().listTasks(org.cloudfoundry.client.v3.applications.ListApplicationTasksRequest.builder().applicationId(applicationId).page(page).sequenceId(sequenceId.toString()).build()));
    }

    private static Flux<Envelope> requestLogsRecent(Mono<DopplerClient> dopplerClient, String applicationId) {
        return dopplerClient.flatMapMany(client -> client.recentLogs(RecentLogsRequest.builder().applicationId(applicationId).build()));
    }

    private static Flux<Envelope> requestLogsStream(Mono<DopplerClient> dopplerClient, String applicationId) {
        return dopplerClient.flatMapMany(client -> client.stream(StreamRequest.builder().applicationId(applicationId).build()));
    }

    private static Flux<SpaceResource> requestOrganizationSpacesByName(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaces(ListOrganizationSpacesRequest.builder().name(space).organizationId(organizationId).page(page).build()));
    }

    private static Flux<OrganizationResource> requestOrganizations(CloudFoundryClient cloudFoundryClient, String organization) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().name(organization).page(page).build()));
    }

    private static Mono<Void> requestRemoveRouteFromApplication(CloudFoundryClient cloudFoundryClient, String applicationId, String routeId) {
        return cloudFoundryClient.applicationsV2().removeRoute(RemoveApplicationRouteRequest.builder().applicationId(applicationId).routeId(routeId).build());
    }

    private static Mono<Void> requestRemoveServiceBinding(CloudFoundryClient cloudFoundryClient, String applicationId, String serviceBindingId) {
        return cloudFoundryClient.applicationsV2().removeServiceBinding(RemoveApplicationServiceBindingRequest.builder().applicationId(applicationId).serviceBindingId(serviceBindingId).build());
    }

    private static Mono<RestageApplicationResponse> requestRestageApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().restage(org.cloudfoundry.client.v2.applications.RestageApplicationRequest.builder().applicationId(applicationId).build());
    }

    private static Flux<RouteResource> requestRoutes(CloudFoundryClient cloudFoundryClient, String domainId, String host, Integer port, String routePath) {
        ListRoutesRequest.Builder requestBuilder = ListRoutesRequest.builder().domainId(domainId);
        Optional.ofNullable(host).ifPresent(arg_0 -> ((ListRoutesRequest.Builder)requestBuilder).host(arg_0));
        Optional.ofNullable(routePath).ifPresent(arg_0 -> ((ListRoutesRequest.Builder)requestBuilder).path(arg_0));
        Optional.ofNullable(port).ifPresent(arg_0 -> ((ListRoutesRequest.Builder)requestBuilder).port(arg_0));
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.routes().list(requestBuilder.page(page).build()));
    }

    private static Flux<SharedDomainResource> requestSharedDomains(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().page(page).build()));
    }

    private static Mono<GetSpaceResponse> requestSpace(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return cloudFoundryClient.spaces().get(GetSpaceRequest.builder().spaceId(spaceId).build());
    }

    private static Mono<GetSpaceSummaryResponse> requestSpaceSummary(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return cloudFoundryClient.spaces().getSummary(GetSpaceSummaryRequest.builder().spaceId(spaceId).build());
    }

    private static Mono<GetStackResponse> requestStack(CloudFoundryClient cloudFoundryClient, String stackId) {
        return cloudFoundryClient.stacks().get(GetStackRequest.builder().stackId(stackId).build());
    }

    private static Flux<StackResource> requestStacks(CloudFoundryClient cloudFoundryClient, String stack) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.stacks().list(ListStacksRequest.builder().page(page).name(stack).build()));
    }

    private static Mono<Void> requestTerminateApplicationInstance(CloudFoundryClient cloudFoundryClient, String applicationId, String instanceIndex) {
        return cloudFoundryClient.applicationsV2().terminateInstance(TerminateApplicationInstanceRequest.builder().applicationId(applicationId).index(instanceIndex).build());
    }

    private static Mono<CancelTaskResponse> requestTerminateTask(CloudFoundryClient cloudFoundryClient, String taskId) {
        return cloudFoundryClient.tasks().cancel(CancelTaskRequest.builder().taskId(taskId).build());
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplication(CloudFoundryClient cloudFoundryClient, String applicationId, Map<String, Object> environmentJsons, ApplicationManifest manifest, String stackId) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> {
            builder.command(manifest.getCommand()).diskQuota(manifest.getDisk()).environmentJsons(environmentJsons).healthCheckHttpEndpoint(manifest.getHealthCheckHttpEndpoint()).healthCheckTimeout(manifest.getTimeout()).healthCheckType((String)Optional.ofNullable(manifest.getHealthCheckType()).map(ApplicationHealthCheck::getValue).orElse(null)).instances(manifest.getInstances()).memory(manifest.getMemory()).name(manifest.getName()).stackId(stackId);
            if (manifest.getBuildpacks() != null && manifest.getBuildpacks().size() == 1) {
                builder.buildpack(manifest.getBuildpacks().get(0));
            }
            if (manifest.getDocker() != null) {
                Optional.ofNullable(manifest.getDocker().getImage()).ifPresent(image -> {
                    builder.diego(Boolean.valueOf(true)).dockerImage(image);
                    String username = manifest.getDocker().getUsername();
                    String password = manifest.getDocker().getPassword();
                    builder.dockerCredentials(DockerCredentials.builder().username(username).password(password).build());
                });
            }
            return builder;
        });
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplication(CloudFoundryClient cloudFoundryClient, String applicationId, UnaryOperator<UpdateApplicationRequest.Builder> modifier) {
        return cloudFoundryClient.applicationsV2().update(((UpdateApplicationRequest.Builder)modifier.apply(org.cloudfoundry.client.v2.applications.UpdateApplicationRequest.builder().applicationId(applicationId))).build()).cast(AbstractApplicationResource.class);
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationEnvironment(CloudFoundryClient cloudFoundryClient, String applicationId, Map<String, Object> environment) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.environmentJsons(environment));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationHealthCheckType(CloudFoundryClient cloudFoundryClient, String applicationId, ApplicationHealthCheck type) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.healthCheckType(type.getValue()));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationName(CloudFoundryClient cloudFoundryClient, String applicationId, String name) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.name(name));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationScale(CloudFoundryClient cloudFoundryClient, String applicationId, Integer disk, Integer instances, Integer memory) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.diskQuota(disk).instances(instances).memory(memory));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationSsh(CloudFoundryClient cloudFoundryClient, String applicationId, Boolean enabled) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.enableSsh(enabled));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationState(CloudFoundryClient cloudFoundryClient, String applicationId, String state) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.state(state));
    }

    private static Mono<UploadApplicationResponse> requestUploadApplication(CloudFoundryClient cloudFoundryClient, String applicationId, Path application, List<ResourceMatchingUtils.ArtifactMetadata> matchedResources) {
        UploadApplicationRequest request = matchedResources.stream().reduce(UploadApplicationRequest.builder().application(application).applicationId(applicationId).async(Boolean.valueOf(true)), (builder, artifactMetadata) -> builder.resource(Resource.builder().hash(artifactMetadata.getHash()).mode(artifactMetadata.getPermissions()).path(artifactMetadata.getPath()).size(Integer.valueOf(artifactMetadata.getSize())).build()), (a, b) -> a).build();
        return cloudFoundryClient.applicationsV2().upload(request);
    }

    private static Mono<Void> restageApplication(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration stagingTimeout, Duration startupTimeout) {
        return DefaultApplications.requestRestageApplication(cloudFoundryClient, applicationId).flatMap(response -> DefaultApplications.waitForStaging(cloudFoundryClient, application, applicationId, stagingTimeout)).then(DefaultApplications.waitForRunning(cloudFoundryClient, application, applicationId, startupTimeout));
    }

    private static Mono<Void> restartApplication(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration stagingTimeout, Duration startupTimeout) {
        return DefaultApplications.stopApplication(cloudFoundryClient, applicationId).then(DefaultApplications.startApplicationAndWait(cloudFoundryClient, application, applicationId, stagingTimeout, startupTimeout));
    }

    private static boolean shouldStartApplication(PushApplicationManifestRequest request, AbstractApplicationResource resource) {
        return DefaultApplications.shouldStartApplication(request) && DefaultApplications.getInstances(resource) > 0;
    }

    private static boolean shouldStartApplication(PushApplicationManifestRequest request) {
        return Optional.ofNullable(request.getNoStart()).orElse(false) == false;
    }

    private static Predicate<AbstractApplicationResource> sshEnabled(Boolean enabled) {
        return resource -> enabled.equals(((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getEnableSsh());
    }

    private static Mono<Void> startApplicationAndWait(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration stagingTimeout, Duration startupTimeout) {
        return DefaultApplications.requestUpdateApplicationState(cloudFoundryClient, applicationId, STARTED_STATE).flatMap(response -> DefaultApplications.waitForStaging(cloudFoundryClient, application, applicationId, stagingTimeout)).then(DefaultApplications.waitForRunning(cloudFoundryClient, application, applicationId, startupTimeout));
    }

    private static Mono<Void> stopAndStartApplication(CloudFoundryClient cloudFoundryClient, String applicationId, String name, PushApplicationManifestRequest request) {
        return DefaultApplications.stopApplication(cloudFoundryClient, applicationId).filter(resource -> DefaultApplications.shouldStartApplication(request, resource)).flatMap(resource -> DefaultApplications.startApplicationAndWait(cloudFoundryClient, name, applicationId, request.getStagingTimeout(), request.getStartupTimeout()));
    }

    private static Mono<AbstractApplicationResource> stopApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestUpdateApplicationState(cloudFoundryClient, applicationId, STOPPED_STATE);
    }

    private static Mono<AbstractApplicationResource> stopApplicationIfNotStopped(CloudFoundryClient cloudFoundryClient, AbstractApplicationResource resource) {
        return DefaultApplications.isNotIn(resource, STOPPED_STATE) ? DefaultApplications.stopApplication(cloudFoundryClient, ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource)) : Mono.just((Object)resource);
    }

    private static ApplicationDetail toApplicationDetail(List<String> buildpacks, SummaryApplicationResponse summaryApplicationResponse, GetStackResponse getStackResponse, List<InstanceDetail> instanceDetails, List<String> urls) {
        if (buildpacks.size() == 0) {
            buildpacks = Collections.singletonList(summaryApplicationResponse.getDetectedBuildpack());
        }
        return ApplicationDetail.builder().buildpacks(buildpacks).diskQuota(summaryApplicationResponse.getDiskQuota()).id(summaryApplicationResponse.getId()).instanceDetails(instanceDetails).instances(summaryApplicationResponse.getInstances()).lastUploaded(DefaultApplications.toDate(summaryApplicationResponse.getPackageUpdatedAt())).memoryLimit(summaryApplicationResponse.getMemory()).name(summaryApplicationResponse.getName()).requestedState(summaryApplicationResponse.getState()).runningInstances(summaryApplicationResponse.getRunningInstances()).stack(getStackResponse.getEntity().getName()).urls(urls).build();
    }

    private static ApplicationEnvironments toApplicationEnvironments(ApplicationEnvironmentResponse response) {
        return ApplicationEnvironments.builder().running(response.getRunningEnvironmentJsons()).staging(response.getStagingEnvironmentJsons()).systemProvided(response.getSystemEnvironmentJsons()).userProvided(response.getEnvironmentJsons()).build();
    }

    private static Mono<ApplicationManifest> toApplicationManifest(List<String> buildpacks, SummaryApplicationResponse response, String stackName) {
        ApplicationManifest.Builder builder = ApplicationManifest.builder().command(response.getCommand()).disk(response.getDiskQuota()).environmentVariables(response.getEnvironmentJsons()).healthCheckHttpEndpoint(response.getHealthCheckHttpEndpoint()).healthCheckType(ApplicationHealthCheck.from(response.getHealthCheckType())).instances(response.getInstances()).memory(response.getMemory()).docker(DefaultApplications.toDocker(response)).name(response.getName()).stack(stackName).timeout(response.getHealthCheckTimeout());
        if (buildpacks != null && !buildpacks.isEmpty()) {
            builder.buildpacks(buildpacks);
        }
        for (org.cloudfoundry.client.v2.routes.Route route : Optional.ofNullable(response.getRoutes()).orElse(Collections.emptyList())) {
            builder.route(Route.builder().route(DefaultApplications.toUrl(route)).build());
        }
        if (Optional.ofNullable(response.getRoutes()).orElse(Collections.emptyList()).isEmpty()) {
            builder.noRoute(true);
        }
        for (ServiceInstance service : Optional.ofNullable(response.getServices()).orElse(Collections.emptyList())) {
            Optional.ofNullable(service.getName()).ifPresent(builder::service);
        }
        return Mono.just((Object)builder.build());
    }

    private static ApplicationSummary toApplicationSummary(SpaceApplicationSummary spaceApplicationSummary) {
        return ApplicationSummary.builder().diskQuota(spaceApplicationSummary.getDiskQuota()).id(spaceApplicationSummary.getId()).instances(spaceApplicationSummary.getInstances()).memoryLimit(spaceApplicationSummary.getMemory()).name(spaceApplicationSummary.getName()).requestedState(spaceApplicationSummary.getState()).runningInstances(spaceApplicationSummary.getRunningInstances()).urls(spaceApplicationSummary.getUrls()).build();
    }

    private static Date toDate(String date) {
        return date == null ? null : DateUtils.parseFromIso8601((String)date);
    }

    private static Date toDate(Double date) {
        return date == null ? null : DateUtils.parseSecondsFromEpoch((Double)date);
    }

    private static Docker toDocker(SummaryApplicationResponse response) {
        if (response.getDockerImage() == null) {
            return null;
        }
        return Docker.builder().image(response.getDockerImage()).username(DefaultApplications.getUsername(response.getDockerCredentials())).password(DefaultApplications.getPassword(response.getDockerCredentials())).build();
    }

    private static DomainSummary toDomain(SharedDomainResource resource) {
        SharedDomainEntity entity = (SharedDomainEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource);
        return DomainSummary.builder().id(ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource)).name(entity.getName()).type(entity.getRouterGroupType()).build();
    }

    private static DomainSummary toDomain(PrivateDomainResource resource) {
        PrivateDomainEntity entity = (PrivateDomainEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource);
        return DomainSummary.builder().id(ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource)).name(entity.getName()).build();
    }

    private static ApplicationHealthCheck toHealthCheck(AbstractApplicationResource resource) {
        String type = ((ApplicationEntity)resource.getEntity()).getHealthCheckType();
        if (ApplicationHealthCheck.HTTP.getValue().equals(type)) {
            return ApplicationHealthCheck.HTTP;
        }
        if (ApplicationHealthCheck.NONE.getValue().equals(type)) {
            return ApplicationHealthCheck.NONE;
        }
        if (ApplicationHealthCheck.PORT.getValue().equals(type)) {
            return ApplicationHealthCheck.PORT;
        }
        if (ApplicationHealthCheck.PROCESS.getValue().equals(type)) {
            return ApplicationHealthCheck.PROCESS;
        }
        return null;
    }

    private static InstanceDetail toInstanceDetail(Map.Entry<String, ApplicationInstanceInfo> entry, ApplicationStatisticsResponse statisticsResponse) {
        InstanceStatistics instanceStatistics = Optional.ofNullable(statisticsResponse.getInstances().get(entry.getKey())).orElse(DefaultApplications.emptyInstanceStats());
        Statistics stats = Optional.ofNullable(instanceStatistics.getStatistics()).orElse(DefaultApplications.emptyApplicationStatistics());
        Usage usage = Optional.ofNullable(stats.getUsage()).orElse(DefaultApplications.emptyApplicationUsage());
        return InstanceDetail.builder().index(entry.getKey()).state(entry.getValue().getState()).since(DefaultApplications.toDate(entry.getValue().getSince())).cpu(usage.getCpu()).memoryUsage(usage.getMemory()).diskUsage(usage.getDisk()).diskQuota(stats.getDiskQuota()).memoryQuota(stats.getMemoryQuota()).build();
    }

    private static Mono<List<InstanceDetail>> toInstanceDetailList(ApplicationInstancesResponse instancesResponse, ApplicationStatisticsResponse statisticsResponse) {
        return Flux.fromIterable(instancesResponse.getInstances().entrySet()).map(entry -> DefaultApplications.toInstanceDetail(entry, statisticsResponse)).collectList();
    }

    private static Task toTask(org.cloudfoundry.client.v3.tasks.Task task) {
        return Task.builder().command(task.getCommand()).sequenceId(task.getSequenceId()).name(task.getName()).startTime(task.getCreatedAt()).state(TaskState.valueOf(task.getState().getValue())).build();
    }

    private static String toUrl(org.cloudfoundry.client.v2.routes.Route route) {
        StringBuilder sb = new StringBuilder();
        if (route.getHost() != null && !route.getHost().isEmpty()) {
            sb.append(route.getHost()).append(".");
        }
        Optional.ofNullable(route.getDomain().getName()).ifPresent(sb::append);
        if (route.getPort() == null) {
            Optional.ofNullable(route.getPath()).ifPresent(sb::append);
        } else {
            sb.append(":").append(route.getPort());
        }
        return sb.toString();
    }

    private static Mono<List<String>> toUrls(List<org.cloudfoundry.client.v2.routes.Route> routes) {
        return Flux.fromIterable(routes).map(DefaultApplications::toUrl).collectList();
    }

    private static Mono<Void> updateBuildpacks(CloudFoundryClient cloudFoundryClient, String applicationId, ApplicationManifest manifest) {
        if (manifest.getBuildpacks() == null || manifest.getBuildpacks().size() < 2) {
            return Mono.empty();
        }
        return cloudFoundryClient.applicationsV3().update(UpdateApplicationRequest.builder().applicationId(applicationId).lifecycle(Lifecycle.builder().data((LifecycleData)BuildpackData.builder().addAllBuildpacks(manifest.getBuildpacks()).build()).type(LifecycleType.BUILDPACK).build()).build()).then();
    }

    private static Mono<Void> uploadApplicationAndWait(CloudFoundryClient cloudFoundryClient, String applicationId, Path application, List<ResourceMatchingUtils.ArtifactMetadata> matchedResources, Duration stagingTimeout) {
        return Mono.defer(() -> {
            if (matchedResources.isEmpty()) {
                return DefaultApplications.requestUploadApplication(cloudFoundryClient, applicationId, application, matchedResources);
            }
            List paths = matchedResources.stream().map(ResourceMatchingUtils.ArtifactMetadata::getPath).collect(Collectors.toList());
            return FileUtils.compress((Path)application, p -> !paths.contains(p)).flatMap(filteredApplication -> DefaultApplications.requestUploadApplication(cloudFoundryClient, applicationId, filteredApplication, matchedResources).doOnTerminate(() -> {
                try {
                    Files.delete(filteredApplication);
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }));
        }).flatMap(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)stagingTimeout, (org.cloudfoundry.client.v2.Resource)job));
    }

    private static Mono<Void> waitForRunning(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration startupTimeout) {
        Duration timeout = Optional.ofNullable(startupTimeout).orElse(Duration.ofMinutes(5L));
        return DefaultApplications.requestApplicationInstances(cloudFoundryClient, applicationId).flatMapMany(response -> Flux.fromIterable(response.getInstances().values())).map(ApplicationInstanceInfo::getState).reduce((Object)"UNKNOWN", DefaultApplications.collectStates()).filter(DefaultApplications.isInstanceComplete()).repeatWhenEmpty(DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(15L), (Duration)timeout)).filter(DefaultApplications.isRunning()).switchIfEmpty(ExceptionUtils.illegalState((String)"Application %s failed during start", (Object[])new Object[]{application})).onErrorResume(DelayTimeoutException.class, t -> ExceptionUtils.illegalState((String)"Application %s timed out during start", (Object[])new Object[]{application})).then();
    }

    private static Mono<Void> waitForStaging(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration stagingTimeout) {
        Duration timeout = Optional.ofNullable(stagingTimeout).orElse(Duration.ofMinutes(15L));
        return DefaultApplications.requestGetApplication(cloudFoundryClient, applicationId).map(response -> ((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)response)).getPackageState()).filter(DefaultApplications.isStagingComplete()).repeatWhenEmpty(DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(15L), (Duration)timeout)).filter(DefaultApplications.isStaged()).switchIfEmpty(ExceptionUtils.illegalState((String)"Application %s failed during staging", (Object[])new Object[]{application})).onErrorResume(DelayTimeoutException.class, t -> ExceptionUtils.illegalState((String)"Application %s timed out during staging", (Object[])new Object[]{application})).then();
    }
}

