/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.util.Arrays;
import java.util.function.Predicate;
import org.cloudfoundry.client.v2.CloudFoundryException;
import reactor.core.publisher.Mono;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static <T> Mono<T> illegalArgument(String format, Object ... args) {
        String message = String.format(format, args);
        return Mono.error((Throwable)new IllegalArgumentException(message));
    }

    public static <T> Mono<T> illegalState(String format, Object ... args) {
        String message = String.format(format, args);
        return Mono.error((Throwable)new IllegalStateException(message));
    }

    public static Predicate<? super Throwable> statusCode(int ... codes) {
        return t -> t instanceof CloudFoundryException && Arrays.stream(codes).anyMatch(candidate -> ((CloudFoundryException)t).getCode().equals(candidate));
    }
}

