/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.cloudfoundry.util.FluentMap;
import reactor.core.Exceptions;

public final class FileUtils {
    private static final Integer DEFAULT_PERMISSIONS = 484;
    private static final Map<PosixFilePermission, Integer> PERMISSION_MODES = FluentMap.builder().entry(PosixFilePermission.OWNER_READ, 256).entry(PosixFilePermission.OWNER_WRITE, 128).entry(PosixFilePermission.OWNER_EXECUTE, 64).entry(PosixFilePermission.GROUP_READ, 32).entry(PosixFilePermission.GROUP_WRITE, 16).entry(PosixFilePermission.GROUP_EXECUTE, 8).entry(PosixFilePermission.OTHERS_READ, 4).entry(PosixFilePermission.OTHERS_WRITE, 2).entry(PosixFilePermission.OTHERS_EXECUTE, 1).build();

    private FileUtils() {
    }

    public static String getRelativePathName(Path root, Path path) {
        Path relative = root.relativize(path);
        return Files.isDirectory(path, new LinkOption[0]) && !relative.toString().endsWith("/") ? String.format("%s/", relative.toString()) : relative.toString();
    }

    public static Path normalize(Path path) {
        try {
            return Files.isDirectory(path, new LinkOption[0]) ? path : FileSystems.newFileSystem(path, null).getPath("/", new String[0]);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static InputStream toInputStream(Path path) {
        return FileUtils.toInputStream(path, p -> true);
    }

    public static InputStream toInputStream(Path path, Predicate<Path> filter) {
        Path root = FileUtils.normalize(path);
        try {
            Path staging = Files.createTempFile(null, null, new FileAttribute[0]);
            try (Stream<Path> contents = Files.walk(root, new FileVisitOption[0]);
                 ZipArchiveOutputStream out = new ZipArchiveOutputStream(staging.toFile());){
                contents.filter(filter).forEach(p -> FileUtils.write(root, p, out));
            }
            return Files.newInputStream(staging, new OpenOption[0]);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static int getUnixMode(Path path) throws IOException {
        return Optional.ofNullable(Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0])).map(attributes -> attributes.permissions().stream().map(PERMISSION_MODES::get).mapToInt(i -> i).sum()).orElse(DEFAULT_PERMISSIONS);
    }

    private static void write(Path root, Path path, ZipArchiveOutputStream out) {
        try {
            if (Files.isSameFile(root, path)) {
                return;
            }
            ZipArchiveEntry entry = new ZipArchiveEntry(FileUtils.getRelativePathName(root, path));
            entry.setUnixMode(FileUtils.getUnixMode(path));
            entry.setLastModifiedTime(Files.getLastModifiedTime(path, new LinkOption[0]));
            out.putArchiveEntry((ArchiveEntry)entry);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                Files.copy(path, (OutputStream)out);
            }
            out.closeArchiveEntry();
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

