/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.util.Optional;
import java.util.function.Function;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v3.PaginatedResponse;
import org.cloudfoundry.util.ResourceUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PaginationUtils {
    private PaginationUtils() {
    }

    public static <T extends Resource<?>, U extends org.cloudfoundry.client.v2.PaginatedResponse<T>> Flux<T> requestClientV2Resources(Function<Integer, Mono<U>> pageSupplier) {
        return pageSupplier.apply(1).flatMap(PaginationUtils.requestClientV2AdditionalPages(pageSupplier)).flatMap(ResourceUtils::getResources);
    }

    public static <T, U extends PaginatedResponse<T>> Flux<T> requestClientV3Resources(Function<Integer, Mono<U>> pageSupplier) {
        return pageSupplier.apply(1).flatMap(PaginationUtils.requestClientV3AdditionalPages(pageSupplier)).flatMapIterable(PaginatedResponse::getResources);
    }

    public static <T, U extends org.cloudfoundry.uaa.PaginatedResponse<T>> Flux<T> requestUaaResources(Function<Integer, Mono<U>> pageSupplier) {
        return pageSupplier.apply(1).flatMap(PaginationUtils.requestUaaAdditionalPages(pageSupplier)).flatMapIterable(org.cloudfoundry.uaa.PaginatedResponse::getResources);
    }

    private static <T> Function<T, Flux<T>> requestAdditionalPages(Function<Integer, Mono<T>> pageSupplier, Function<T, Integer> totalPagesSupplier) {
        return response -> {
            Integer totalPages = Optional.ofNullable(totalPagesSupplier.apply(response)).orElse(1);
            return Flux.range((int)2, (int)(totalPages - 1)).flatMap(pageSupplier).startWith(new Object[]{response}).buffer().flatMapIterable(d -> d);
        };
    }

    private static <T extends org.cloudfoundry.client.v2.PaginatedResponse<?>> Function<T, Flux<T>> requestClientV2AdditionalPages(Function<Integer, Mono<T>> pageSupplier) {
        return PaginationUtils.requestAdditionalPages(pageSupplier, response -> response.getTotalPages());
    }

    private static <T extends PaginatedResponse<?>> Function<T, Flux<T>> requestClientV3AdditionalPages(Function<Integer, Mono<T>> pageSupplier) {
        return PaginationUtils.requestAdditionalPages(pageSupplier, response -> response.getPagination().getTotalPages());
    }

    private static <T extends org.cloudfoundry.uaa.PaginatedResponse<?>> Function<T, Flux<T>> requestUaaAdditionalPages(Function<Integer, Mono<T>> pageSupplier) {
        return response -> {
            Integer totalPages = (response.getTotalResults() - 1) / response.getItemsPerPage() + 1;
            return Flux.range((int)1, (int)(totalPages - 1)).map(page -> 1 + page * response.getItemsPerPage()).flatMap(pageSupplier).startWith((Object[])new org.cloudfoundry.uaa.PaginatedResponse[]{response}).buffer().flatMapIterable(d -> d);
        };
    }
}

