/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.time.Duration;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.ClientV2Exception;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.jobs.ErrorDetails;
import org.cloudfoundry.client.v2.jobs.GetJobRequest;
import org.cloudfoundry.client.v2.jobs.GetJobResponse;
import org.cloudfoundry.client.v2.jobs.JobEntity;
import org.cloudfoundry.util.DelayUtils;
import org.cloudfoundry.util.ResourceUtils;
import reactor.core.publisher.Mono;

public final class JobUtils {
    private JobUtils() {
    }

    public static <R extends Resource<JobEntity>> Mono<Void> waitForCompletion(CloudFoundryClient cloudFoundryClient, R resource) {
        Mono job = JobUtils.isComplete((JobEntity)ResourceUtils.getEntity(resource)) ? Mono.just(ResourceUtils.getEntity(resource)) : JobUtils.requestJob(cloudFoundryClient, ResourceUtils.getId(resource)).map(GetJobResponse::getEntity).filter(JobUtils::isComplete).repeatWhenEmpty(DelayUtils.exponentialBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(15L), Duration.ofMinutes(5L)));
        return job.filter(entity -> "failed".equals(entity.getStatus())).then(JobUtils::getError);
    }

    private static Mono<Void> getError(JobEntity entity) {
        ErrorDetails errorDetails = entity.getErrorDetails();
        return Mono.error((Throwable)new ClientV2Exception(null, errorDetails.getCode(), errorDetails.getDescription(), errorDetails.getErrorCode()));
    }

    private static boolean isComplete(JobEntity entity) {
        String status = entity.getStatus();
        return "finished".equals(status) || "failed".equals(status);
    }

    private static Mono<GetJobResponse> requestJob(CloudFoundryClient cloudFoundryClient, String jobId) {
        return cloudFoundryClient.jobs().get(GetJobRequest.builder().jobId(jobId).build());
    }
}

