/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public final class ByteArrayPool {
    private static final AtomicLong EVICTOR_COUNTER = new AtomicLong();
    private static final ThreadFactory EVICTOR_FACTORY = r -> {
        Thread t = new Thread(r, "byte-buffer-evictor-" + EVICTOR_COUNTER.incrementAndGet());
        t.setDaemon(true);
        return t;
    };
    private static final int MIBIBYTE = 0x100000;
    private static ByteArrayPool INSTANCE = new ByteArrayPool(0x100000, Duration.ofMinutes(1L));
    private final Queue<ByteArrayExpiry> cache = new ConcurrentLinkedQueue<ByteArrayExpiry>();
    private final int capacity;
    private final Duration ttl;

    private ByteArrayPool(int capacity, Duration ttl) {
        this.capacity = capacity;
        this.ttl = ttl;
        Executors.newScheduledThreadPool(1, EVICTOR_FACTORY).scheduleAtFixedRate(this::evict, ttl.toMillis(), ttl.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static void withByteArray(Consumer<byte[]> consumer) {
        INSTANCE.doWithByteArray(consumer);
    }

    private void doWithByteArray(Consumer<byte[]> consumer) {
        byte[] byteArray = Optional.ofNullable(this.cache.poll()).map(rec$ -> ((ByteArrayExpiry)rec$).getByteArray()).orElseGet(() -> new byte[this.capacity]);
        try {
            consumer.accept(byteArray);
        }
        finally {
            this.cache.offer(new ByteArrayExpiry(byteArray, Instant.now().plus(this.ttl)));
        }
    }

    private void evict() {
        Instant now = Instant.now();
        new ArrayList<ByteArrayExpiry>(this.cache).stream().filter(expiry -> ((ByteArrayExpiry)expiry).getExpiration().isBefore(now)).forEach(this.cache::remove);
    }

    private static class ByteArrayExpiry {
        private final byte[] byteArray;
        private final Instant expiration;

        private ByteArrayExpiry(byte[] byteArray, Instant expiration) {
            this.byteArray = byteArray;
            this.expiration = expiration;
        }

        private byte[] getByteArray() {
            return this.byteArray;
        }

        private Instant getExpiration() {
            return this.expiration;
        }
    }
}

