/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.reconfiguration.BeanUtils;
import org.cloudfoundry.reconfiguration.CloudServicesHolder;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

final class ApplicationContextCloudServicesHolder
implements CloudServicesHolder {
    private static final Logger LOGGER = Logger.getLogger(ApplicationContextCloudServicesHolder.class.getName());
    private final boolean isUsingCloudServices;

    ApplicationContextCloudServicesHolder(ApplicationContext applicationContext) {
        this.isUsingCloudServices = ApplicationContextCloudServicesHolder.isUsingCloudServices(applicationContext);
    }

    @Override
    public void withCloudServices(Runnable ifUsingCloudServices, Runnable ifNotUsingCloudServices) {
        if (this.isUsingCloudServices) {
            ifUsingCloudServices.run();
        } else {
            ifNotUsingCloudServices.run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Stream<String> getCloudServiceClasses(Resource resource) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
            Stream<String> stream = in.lines().map(String::trim).collect(Collectors.toSet()).stream();
            return stream;
        }
        catch (IOException e) {
            LOGGER.warning(String.format("Unable to read cloud service classes from %s", resource.getFilename()));
            return Stream.empty();
        }
    }

    private static boolean isClassPresent(String className) {
        return ClassUtils.isPresent((String)className, null);
    }

    private static boolean isUsingCloudServices(ApplicationContext applicationContext) {
        try {
            return Arrays.stream(applicationContext.getResources("classpath*:/META-INF/cloud/cloud-services")).flatMap(ApplicationContextCloudServicesHolder::getCloudServiceClasses).filter(ApplicationContextCloudServicesHolder::isClassPresent).anyMatch(klass -> BeanUtils.hasBeansOfType((ListableBeanFactory)applicationContext, klass));
        }
        catch (IOException e) {
            LOGGER.warning("Unable to read cloud service classes");
            return false;
        }
    }
}

