/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration;

import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.ClassUtils;

final class BeanUtils {
    private BeanUtils() {
    }

    static int getCountOfBeansForType(ListableBeanFactory beanFactory, Class<?> klass) {
        return BeanUtils.getBeanNamesForType(beanFactory, klass).length;
    }

    static String getSingleBeanName(ListableBeanFactory beanFactory, Class<?> klass) {
        return BeanUtils.getBeanNamesForType(beanFactory, klass)[0];
    }

    static boolean hasBeansOfType(ListableBeanFactory beanFactory, Class<?> klass) {
        return BeanUtils.getCountOfBeansForType(beanFactory, klass) != 0;
    }

    static boolean hasBeansOfType(ListableBeanFactory beanFactory, String className) {
        return BeanUtils.hasBeansOfType(beanFactory, ClassUtils.resolveClassName((String)className, null));
    }

    private static String[] getBeanNamesForType(ListableBeanFactory beanFactory, Class<?> klass) {
        return beanFactory.getBeanNamesForType(klass, false, false);
    }
}

