/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration;

import org.cloudfoundry.reconfiguration.CloudHolder;
import org.cloudfoundry.reconfiguration.ProfileUtils;
import org.cloudfoundry.reconfiguration.SharedCloudHolder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

public final class CloudProfileApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private final CloudHolder cloudHolder;

    public CloudProfileApplicationContextInitializer() {
        this(SharedCloudHolder.getInstance());
    }

    CloudProfileApplicationContextInitializer(CloudHolder cloudHolder) {
        this.cloudHolder = cloudHolder;
    }

    public int getOrder() {
        return 100;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ProfileUtils.activateProfile("cloud", applicationContext.getEnvironment(), this.cloudHolder);
    }
}

