/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration;

import java.util.logging.Logger;
import org.cloudfoundry.reconfiguration.CloudHolder;
import org.cloudfoundry.reconfiguration.SharedCloudHolder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public final class CloudPropertySourceApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final CloudHolder cloudHolder;

    public CloudPropertySourceApplicationContextInitializer() {
        this(SharedCloudHolder.getInstance());
    }

    CloudPropertySourceApplicationContextInitializer(CloudHolder cloudHolder) {
        this.cloudHolder = cloudHolder;
    }

    public int getOrder() {
        return 200;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.cloudHolder.withCloud(() -> this.logger.warning(String.format("Skipping '%s' property source addition because not in a cloud", "cloud")), cloud -> {
            applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)new PropertiesPropertySource("cloud", cloud.getCloudProperties()));
            this.logger.info("'cloud' property source added");
        });
    }
}

