/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration;

import java.util.logging.Logger;
import org.cloudfoundry.reconfiguration.CloudHolder;
import org.cloudfoundry.reconfiguration.CloudServiceReconfigurationBeanFactoryPostProcessor;
import org.cloudfoundry.reconfiguration.SharedCloudHolder;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.Cloud;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

public final class CloudServiceReconfigurationApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final CloudHolder cloudHolder;

    public CloudServiceReconfigurationApplicationContextInitializer() {
        this(SharedCloudHolder.getInstance());
    }

    CloudServiceReconfigurationApplicationContextInitializer(CloudHolder cloudHolder) {
        this.cloudHolder = cloudHolder;
    }

    public int getOrder() {
        return 300;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.cloudHolder.withCloud(() -> this.logger.warning("Skipping reconfiguration because not in a cloud"), cloud -> {
            applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new CloudServiceReconfigurationBeanFactoryPostProcessor((ApplicationContext)applicationContext, (Cloud)cloud));
            this.logger.info("Reconfiguration enabled");
        });
    }
}

