/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration;

import java.util.logging.Logger;
import org.cloudfoundry.reconfiguration.ApplicationContextCloudServicesHolder;
import org.cloudfoundry.reconfiguration.CloudServiceUtils;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.Cloud;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;

final class CloudServiceReconfigurationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ApplicationContext applicationContext;
    private final Cloud cloud;

    CloudServiceReconfigurationBeanFactoryPostProcessor(ApplicationContext applicationContext, Cloud cloud) {
        this.applicationContext = applicationContext;
        this.cloud = cloud;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        new ApplicationContextCloudServicesHolder(this.applicationContext).withCloudServices(() -> this.logger.info("Skipping reconfiguration because cloud services already configured"), () -> {
            CloudServiceUtils.replaceBeanOfType("com.datastax.driver.core.Cluster", (DefaultListableBeanFactory)beanFactory, this.cloud);
            CloudServiceUtils.replaceBeanOfType("org.springframework.data.mongodb.MongoDbFactory", (DefaultListableBeanFactory)beanFactory, this.cloud);
            CloudServiceUtils.replaceBeanOfType("org.springframework.data.redis.connection.RedisConnectionFactory", (DefaultListableBeanFactory)beanFactory, this.cloud);
            CloudServiceUtils.replaceBeanOfType("org.springframework.amqp.rabbit.connection.ConnectionFactory", (DefaultListableBeanFactory)beanFactory, this.cloud);
            CloudServiceUtils.replaceBeanOfType("javax.sql.DataSource", (DefaultListableBeanFactory)beanFactory, this.cloud);
            CloudServiceUtils.replaceBeanOfType("org.springframework.mail.javamail.JavaMailSender", (DefaultListableBeanFactory)beanFactory, this.cloud);
        });
    }
}

