/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration;

import java.util.logging.Logger;
import org.cloudfoundry.reconfiguration.BeanUtils;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.Cloud;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.ClassUtils;

final class CloudServiceUtils {
    private static final Logger LOGGER = Logger.getLogger(CloudServiceUtils.class.getName());

    private CloudServiceUtils() {
    }

    static void replaceBeanOfType(String className, DefaultListableBeanFactory beanFactory, Cloud cloud) {
        if (!ClassUtils.isPresent((String)className, null)) {
            return;
        }
        Class klass = ClassUtils.resolveClassName((String)className, null);
        if (!CloudServiceUtils.hasSingleBean((ListableBeanFactory)beanFactory, klass) || !CloudServiceUtils.hasSingleCloudService(cloud, klass)) {
            return;
        }
        String beanName = BeanUtils.getSingleBeanName((ListableBeanFactory)beanFactory, klass);
        String cloudServiceBeanName = CloudServiceUtils.getSingleCloudServiceName(cloud, klass);
        beanFactory.registerSingleton(cloudServiceBeanName, CloudServiceUtils.getSingleCloudService(cloud, klass));
        beanFactory.removeBeanDefinition(beanName);
        beanFactory.registerAlias(cloudServiceBeanName, beanName);
        LOGGER.info(String.format("'%s' bean of type with '%s' reconfigured with '%s' bean", beanName, className, cloudServiceBeanName));
    }

    private static Object getSingleCloudService(Cloud cloud, Class<?> klass) {
        return cloud.getSingletonServiceConnector(klass, null);
    }

    private static String getSingleCloudServiceName(Cloud cloud, Class<?> klass) {
        return cloud.getServiceInfos(klass).get(0).getId();
    }

    private static boolean hasSingleBean(ListableBeanFactory beanFactory, Class<?> klass) {
        int size = BeanUtils.getCountOfBeansForType(beanFactory, klass);
        if (size == 0) {
            LOGGER.fine(String.format("Skipping reconfiguration of '%s' because there were no beans of type", klass.getName()));
            return false;
        }
        if (size > 1) {
            LOGGER.fine(String.format("Skipping reconfiguration of '%s' because there multiple beans of type", klass.getName()));
            return false;
        }
        return true;
    }

    private static boolean hasSingleCloudService(Cloud cloud, Class<?> klass) {
        int size = cloud.getServiceInfos(klass).size();
        if (size == 0) {
            LOGGER.fine(String.format("Skipping reconfiguration of '%s' because there were no services of type", klass.getName()));
            return false;
        }
        if (size > 1) {
            LOGGER.fine(String.format("Skipping reconfiguration of '%s' because there multiple services of type", klass.getName()));
            return false;
        }
        return true;
    }
}

