/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration;

import java.util.logging.Logger;
import org.cloudfoundry.reconfiguration.CloudHolder;
import org.springframework.core.env.ConfigurableEnvironment;

final class ProfileUtils {
    private static final Logger LOGGER = Logger.getLogger(ProfileUtils.class.getName());

    private ProfileUtils() {
    }

    static void activateProfile(String profile, ConfigurableEnvironment environment, CloudHolder cloudHolder) {
        cloudHolder.withCloud(() -> LOGGER.warning(String.format("Skipping '%s' profile activation because not in a cloud", profile)), cloud -> {
            environment.addActiveProfile(profile);
            LOGGER.info(String.format("'%s' profile activated", profile));
        });
    }
}

