/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry;

import java.util.List;
import java.util.Map;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.Tags;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.common.CassandraServiceInfo;

public class CassandraServiceInfoCreator
extends CloudFoundryServiceInfoCreator<CassandraServiceInfo> {
    public CassandraServiceInfoCreator() {
        super(new Tags("cassandra"), new String[0]);
    }

    @Override
    public boolean accept(Map<String, Object> serviceData) {
        return this.cassandraCredentialsPresent(serviceData);
    }

    private boolean cassandraCredentialsPresent(Map<String, Object> serviceData) {
        Map<String, Object> credentials = this.getCredentials(serviceData);
        return credentials != null && credentials.containsKey("cqlsh_port") && credentials.containsKey("node_ips");
    }

    @Override
    public CassandraServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String id = (String)serviceData.get("name");
        Map<String, Object> credentials = this.getCredentials(serviceData);
        String username = this.getStringFromCredentials(credentials, "username");
        String password = this.getStringFromCredentials(credentials, "password");
        int port = this.getIntFromCredentials(credentials, "cqlsh_port");
        List contactPoints = (List)credentials.get("node_ips");
        return new CassandraServiceInfo(id, contactPoints, port, username, password);
    }
}

