/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.AbstractCloudConnector;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.CloudException;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.FallbackServiceInfoCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.app.ApplicationInstanceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.ApplicationInstanceInfoCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.CloudFoundryFallbackServiceInfoCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.CloudFoundryRawServiceData;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.ServiceDataPostProcessor;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.BaseServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.util.EnvironmentAccessor;

public class CloudFoundryConnector
extends AbstractCloudConnector<Map<String, Object>> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private EnvironmentAccessor environment = new EnvironmentAccessor();
    private ApplicationInstanceInfoCreator applicationInstanceInfoCreator = new ApplicationInstanceInfoCreator();
    private Iterable<ServiceDataPostProcessor> serviceDataPostProcessors;

    public CloudFoundryConnector() {
        super(CloudFoundryServiceInfoCreator.class);
        this.scanServiceDataPostProcessors();
    }

    @Override
    public boolean isInMatchingCloud() {
        return this.environment.getEnvValue("VCAP_APPLICATION") != null;
    }

    @Override
    public ApplicationInstanceInfo getApplicationInstanceInfo() {
        try {
            Map rawApplicationInstanceInfo = this.objectMapper.readValue(this.environment.getEnvValue("VCAP_APPLICATION"), Map.class);
            return this.applicationInstanceInfoCreator.createApplicationInstanceInfo(rawApplicationInstanceInfo);
        }
        catch (Exception e) {
            throw new CloudException(e);
        }
    }

    void setCloudEnvironment(EnvironmentAccessor environment) {
        this.environment = environment;
    }

    @Override
    protected List<Map<String, Object>> getServicesData() {
        String servicesString = this.environment.getEnvValue("VCAP_SERVICES");
        CloudFoundryRawServiceData rawServices = new CloudFoundryRawServiceData();
        if (servicesString != null && servicesString.length() > 0) {
            try {
                rawServices = this.objectMapper.readValue(servicesString, CloudFoundryRawServiceData.class);
            }
            catch (Exception e) {
                throw new CloudException(e);
            }
        }
        for (ServiceDataPostProcessor postProcessor : this.serviceDataPostProcessors) {
            rawServices = postProcessor.process(rawServices);
        }
        ArrayList<Map<String, Object>> flatServices = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : rawServices.entrySet()) {
            flatServices.addAll((Collection)entry.getValue());
        }
        return flatServices;
    }

    @Override
    protected FallbackServiceInfoCreator<BaseServiceInfo, Map<String, Object>> getFallbackServiceInfoCreator() {
        return new CloudFoundryFallbackServiceInfoCreator();
    }

    private void scanServiceDataPostProcessors() {
        this.serviceDataPostProcessors = ServiceLoader.load(ServiceDataPostProcessor.class);
    }
}

