/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry;

import java.util.Map;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.Tags;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.common.RelationalServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.util.UriInfo;

public abstract class RelationalServiceInfoCreator<SI extends RelationalServiceInfo>
extends CloudFoundryServiceInfoCreator<SI> {
    public RelationalServiceInfoCreator(Tags tags, String ... uriSchemes) {
        super(tags, uriSchemes);
    }

    @Override
    public boolean accept(Map<String, Object> serviceData) {
        return this.jdbcUrlMatchesScheme(serviceData) || super.accept(serviceData);
    }

    protected boolean jdbcUrlMatchesScheme(Map<String, Object> serviceData) {
        if (this.getUriSchemes() == null) {
            return false;
        }
        Map<String, Object> credentials = this.getCredentials(serviceData);
        String jdbcUrl = this.getStringFromCredentials(credentials, "jdbcUrl");
        if (jdbcUrl != null) {
            for (String uriScheme : this.getUriSchemes()) {
                if (!jdbcUrl.startsWith("jdbc:" + uriScheme + ":")) continue;
                return true;
            }
        }
        return false;
    }

    public abstract SI createServiceInfo(String var1, String var2, String var3);

    @Override
    public SI createServiceInfo(Map<String, Object> serviceData) {
        String id = this.getId(serviceData);
        Map<String, Object> credentials = this.getCredentials(serviceData);
        String jdbcUrl = this.getStringFromCredentials(credentials, "jdbcUrl");
        String uri = this.getUriFromCredentials(credentials);
        if (uri == null) {
            String host = this.getStringFromCredentials(credentials, "hostname", "host");
            int port = this.getIntFromCredentials(credentials, "port");
            String username = this.getStringFromCredentials(credentials, "user", "username");
            String password = (String)credentials.get("password");
            String database = (String)credentials.get("name");
            if (host != null) {
                uri = new UriInfo(this.getDefaultUriScheme(), host, port, username, password, database).toString();
            }
        }
        if (uri == null) {
            uri = jdbcUrl;
        }
        return this.createServiceInfo(id, uri, jdbcUrl);
    }
}

