/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry;

import java.util.Map;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.cloudfoundry.Tags;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.common.SmtpServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.util.UriInfo;

public class SmtpServiceInfoCreator
extends CloudFoundryServiceInfoCreator<SmtpServiceInfo> {
    private static final int DEFAULT_SMTP_PORT = 587;

    public SmtpServiceInfoCreator() {
        super(new Tags("smtp"), "smtp");
    }

    @Override
    public SmtpServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String id = this.getId(serviceData);
        Map<String, Object> credentials = this.getCredentials(serviceData);
        String uri = this.getUriFromCredentials(credentials);
        if (uri == null) {
            String host = this.getStringFromCredentials(credentials, "host", "hostname");
            int port = this.getIntFromCredentials(credentials, "port");
            if (port == -1) {
                port = 587;
            }
            String username = this.getStringFromCredentials(credentials, "user", "username");
            String password = this.getStringFromCredentials(credentials, "password");
            uri = new UriInfo("smtp", host, port, username, password).toString();
        }
        return new SmtpServiceInfo(id, uri);
    }
}

