/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.config.java;

import java.util.Properties;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.Cloud;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.CloudFactory;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.config.java.CloudServiceConnectionFactory;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.config.java.ServiceConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public abstract class AbstractCloudConfig
implements BeanFactoryAware {
    private static final String CLOUD_FACTORY_BEAN_NAME = "__cloud_factory__";
    private CloudFactory cloudFactory;
    private Cloud cloud;
    private ServiceConnectionFactory connectionFactory;

    protected CloudFactory cloudFactory() {
        return this.cloudFactory;
    }

    @Bean
    public Cloud cloud() {
        return this.cloud;
    }

    public ServiceConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    public Properties properties() {
        return this.cloud().getCloudProperties();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.cloudFactory == null) {
            try {
                this.cloudFactory = (CloudFactory)beanFactory.getBean(CloudFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.cloudFactory = new CloudFactory();
                ((SingletonBeanRegistry)beanFactory).registerSingleton(CLOUD_FACTORY_BEAN_NAME, (Object)this.cloudFactory);
            }
        }
        this.cloud = this.cloudFactory.getCloud();
        this.connectionFactory = new CloudServiceConnectionFactory(this.cloud);
    }
}

