/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.config.xml;

import com.datastax.driver.core.ProtocolOptions;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.config.xml.AbstractNestedElementCloudServiceFactoryParser;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.column.CassandraClusterConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.column.CassandraClusterFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CloudCassandraSessionParser
extends AbstractNestedElementCloudServiceFactoryParser {
    final String ELEMENT_CASSANDRA_OPTIONS = "cassandra-options";
    final String COMPRESSION_ATTRIBUTE = "compression";
    final String RETRY_POLICY_ATTRIBUTE = "retry-policy";
    final String LOAD_BALANCING_POLICY_ATTRIBUTE = "loadbalancing-policy";
    final String SOCKET_OPTIONS_ATTRIBUTE = "socket-options";
    final String RECONNECTION_POLICY_ATTRIBUTE = "reconnection-policy";

    public CloudCassandraSessionParser() {
        super(CassandraClusterFactory.class);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        Element optionsElement = DomUtils.getChildElementByTagName((Element)element, (String)"cassandra-options");
        BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)CassandraClusterConfig.class.getName());
        if (optionsElement != null) {
            String reconnectionPolicyString;
            String socketOptionsString;
            String loadBalancingPolicyString;
            String retryPolicyString;
            String compressionString = optionsElement.getAttribute("compression");
            if (!StringUtils.isEmpty((Object)compressionString)) {
                ProtocolOptions.Compression compression = ProtocolOptions.Compression.valueOf((String)compressionString);
                beanBuilder.addPropertyValue("compression", (Object)compression);
            }
            if (!StringUtils.isEmpty((Object)(retryPolicyString = optionsElement.getAttribute("retry-policy")))) {
                beanBuilder.addPropertyReference("retryPolicy", retryPolicyString);
            }
            if (!StringUtils.isEmpty((Object)(loadBalancingPolicyString = optionsElement.getAttribute("loadbalancing-policy")))) {
                beanBuilder.addPropertyReference("loadBalancingPolicy", loadBalancingPolicyString);
            }
            if (!StringUtils.isEmpty((Object)(socketOptionsString = optionsElement.getAttribute("socket-options")))) {
                beanBuilder.addPropertyReference("socketOptions", socketOptionsString);
            }
            if (!StringUtils.isEmpty((Object)(reconnectionPolicyString = optionsElement.getAttribute("reconnection-policy")))) {
                beanBuilder.addPropertyReference("reconnectionPolicy", reconnectionPolicyString);
            }
        }
        builder.addConstructorArgValue((Object)beanBuilder.getBeanDefinition());
    }
}

