/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.config.xml;

import java.util.List;
import java.util.Map;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.config.xml.AbstractPoolingCloudServiceFactoryParser;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational.CloudDataSourceFactory;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.relational.DataSourceConfig;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CloudDataSourceFactoryParser
extends AbstractPoolingCloudServiceFactoryParser {
    private static final String ELEMENT_CONNECTION = "connection";
    private static final String ELEMENT_POOL = "pool";
    private static final String ELEMENT_DATASOURCE_NAMES = "pool-data-sources";
    private static final String ELEMENT_CONNECTION_PROPERTIES = "connection-properties";

    public CloudDataSourceFactoryParser() {
        super(CloudDataSourceFactory.class);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        BeanDefinitionBuilder dataSourceConfigBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DataSourceConfig.class.getName());
        BeanDefinition cloudConnectionConfiguration = null;
        Element connectionElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_CONNECTION);
        if (connectionElement != null) {
            cloudConnectionConfiguration = this.parseConnectionElement(connectionElement);
        }
        BeanDefinition cloudPoolConfiguration = null;
        Element poolElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_POOL);
        if (poolElement != null) {
            cloudPoolConfiguration = this.parsePoolElement(poolElement, parserContext);
        }
        List dataSourceNames = null;
        Element dataSourceNamesElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_DATASOURCE_NAMES);
        if (dataSourceNamesElement != null) {
            dataSourceNames = parserContext.getDelegate().parseListElement(dataSourceNamesElement, (BeanDefinition)dataSourceConfigBeanBuilder.getRawBeanDefinition());
        }
        Map properties = null;
        Element propertiesElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_CONNECTION_PROPERTIES);
        if (propertiesElement != null) {
            properties = parserContext.getDelegate().parseMapElement(propertiesElement, (BeanDefinition)builder.getRawBeanDefinition());
        }
        dataSourceConfigBeanBuilder.addConstructorArgValue((Object)cloudPoolConfiguration);
        dataSourceConfigBeanBuilder.addConstructorArgValue((Object)cloudConnectionConfiguration);
        dataSourceConfigBeanBuilder.addConstructorArgValue((Object)dataSourceNames);
        dataSourceConfigBeanBuilder.addConstructorArgValue((Object)properties);
        builder.addConstructorArgValue((Object)dataSourceConfigBeanBuilder.getBeanDefinition());
    }

    private BeanDefinition parseConnectionElement(Element element) {
        BeanDefinitionBuilder cloudConnectionConfigurationBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DataSourceConfig.ConnectionConfig.class.getName());
        String connectionProperties = element.getAttribute("properties");
        if (StringUtils.hasText((String)connectionProperties)) {
            cloudConnectionConfigurationBeanBuilder.addConstructorArgValue((Object)connectionProperties);
        }
        return cloudConnectionConfigurationBeanBuilder.getBeanDefinition();
    }
}

