/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.config.xml;

import java.util.Map;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.config.xml.AbstractNestedElementCloudServiceFactoryParser;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.messaging.RabbitConnectionFactoryConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.messaging.RabbitConnectionFactoryFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CloudRabbitConnectionFactoryParser
extends AbstractNestedElementCloudServiceFactoryParser {
    private static final String RABBIT_OPTIONS = "rabbit-options";
    private static final String CONNECTION_PROPERTIES = "connection-properties";
    private static final String CHANNEL_CACHE_SIZE = "channel-cache-size";

    public CloudRabbitConnectionFactoryParser() {
        super(RabbitConnectionFactoryFactory.class);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        BeanDefinition cloudRabbitConfiguration = this.parseRabbitOptionsElement(element, parserContext);
        builder.addConstructorArgValue((Object)cloudRabbitConfiguration);
    }

    private BeanDefinition parseRabbitOptionsElement(Element element, ParserContext parserContext) {
        Element rabbitOptionsElement;
        BeanDefinitionBuilder configBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)RabbitConnectionFactoryConfig.class.getName());
        Element propertiesElement = DomUtils.getChildElementByTagName((Element)element, (String)CONNECTION_PROPERTIES);
        if (propertiesElement != null) {
            Map properties = parserContext.getDelegate().parseMapElement(propertiesElement, (BeanDefinition)configBeanBuilder.getRawBeanDefinition());
            configBeanBuilder.addConstructorArgValue((Object)properties);
        }
        if ((rabbitOptionsElement = DomUtils.getChildElementByTagName((Element)element, (String)RABBIT_OPTIONS)) != null) {
            String channelCacheSize = rabbitOptionsElement.getAttribute(CHANNEL_CACHE_SIZE);
            configBeanBuilder.addConstructorArgValue((Object)channelCacheSize);
        }
        if (propertiesElement == null && rabbitOptionsElement == null) {
            return null;
        }
        return configBeanBuilder.getBeanDefinition();
    }
}

