/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.config.xml;

import java.lang.reflect.Constructor;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.AbstractCloudServiceConnectorFactory;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.CloudServiceConnectorFactory;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.StringUtils;

class CloudServiceIntroducer
implements BeanFactoryPostProcessor {
    private Class<? extends CloudServiceConnectorFactory<?>> serviceConnectorFactoryType;
    private String beanId;
    private String serviceId;
    private ServiceConnectorConfig serviceConnectorConfig;
    private Class<?> serviceConnectorType;

    public CloudServiceIntroducer(Class<? extends CloudServiceConnectorFactory<?>> serviceConnectorFactoryType, String beanId, String serviceId, ServiceConnectorConfig serviceConnectorConfig) {
        this.serviceConnectorFactoryType = serviceConnectorFactoryType;
        this.beanId = beanId;
        this.serviceId = serviceId;
        this.serviceConnectorConfig = serviceConnectorConfig;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            Constructor<CloudServiceConnectorFactory<?>> ctor = this.serviceConnectorFactoryType.getConstructor(String.class, ServiceConnectorConfig.class);
            AbstractCloudServiceConnectorFactory serviceFactory = (AbstractCloudServiceConnectorFactory)ctor.newInstance(this.serviceId, this.serviceConnectorConfig);
            serviceFactory.setServiceConnectorType(this.serviceConnectorType);
            serviceFactory.setBeanFactory((BeanFactory)beanFactory);
            serviceFactory.afterPropertiesSet();
            if (StringUtils.hasText((String)this.beanId)) {
                beanFactory.registerSingleton(this.beanId, (Object)serviceFactory);
            } else {
                beanFactory.registerSingleton(serviceFactory.getServiceId(), (Object)serviceFactory);
            }
        }
        catch (Exception ex) {
            throw new BeanCreationException("Error registering service factory", (Throwable)ex);
        }
    }

    public void setServiceConnectorType(Class<?> serviceConnectorType) {
        this.serviceConnectorType = serviceConnectorType;
    }
}

