/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service;

import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.BaseServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.util.StandardUriInfoFactory;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.util.UriInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.util.UriInfoFactory;

public abstract class UriBasedServiceInfo
extends BaseServiceInfo {
    private UriInfo uriInfo;
    private static UriInfoFactory uriFactory = new StandardUriInfoFactory();

    public UriBasedServiceInfo(String id, String scheme, String host, int port, String username, String password, String path) {
        super(id);
        this.uriInfo = this.getUriInfoFactory().createUri(scheme, host, port, username, password, path);
        this.uriInfo = this.validateAndCleanUriInfo(this.uriInfo);
    }

    public UriBasedServiceInfo(String id, String uriString) {
        super(id);
        this.uriInfo = this.getUriInfoFactory().createUri(uriString);
        this.uriInfo = this.validateAndCleanUriInfo(this.uriInfo);
    }

    public UriInfoFactory getUriInfoFactory() {
        return uriFactory;
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getUri() {
        return this.uriInfo.getUriString();
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getUserName() {
        return this.uriInfo.getUserName();
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getPassword() {
        return this.uriInfo.getPassword();
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getHost() {
        return this.uriInfo.getHost();
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public int getPort() {
        return this.uriInfo.getPort();
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getPath() {
        return this.uriInfo.getPath();
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getQuery() {
        return this.uriInfo.getQuery();
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getScheme() {
        return this.uriInfo.getScheme();
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getSchemeSpecificPart() {
        return this.uriInfo.getSchemeSpecificPart();
    }

    protected UriInfo validateAndCleanUriInfo(UriInfo uriInfo) {
        return uriInfo;
    }

    protected UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getScheme() + "://" + this.getUserName() + ":****@" + this.getHost() + ":" + this.getPort() + "/" + this.getPath() + "]";
    }
}

