/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service;

import org.cloudfoundry.reconfiguration.org.springframework.cloud.ServiceInfoCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.UriBasedServiceData;

public abstract class UriBasedServiceInfoCreator<SI extends ServiceInfo>
implements ServiceInfoCreator<ServiceInfo, UriBasedServiceData> {
    private final String[] uriSchemes;

    public UriBasedServiceInfoCreator(String ... uriSchemes) {
        this.uriSchemes = uriSchemes;
    }

    @Override
    public boolean accept(UriBasedServiceData serviceData) {
        String uriString = serviceData.getUri();
        for (String uriScheme : this.uriSchemes) {
            if (!uriString.startsWith(uriScheme + "://")) continue;
            return true;
        }
        return false;
    }

    public abstract SI createServiceInfo(String var1, String var2);

    @Override
    public SI createServiceInfo(UriBasedServiceData serviceData) {
        return this.createServiceInfo(serviceData.getKey(), serviceData.getUri());
    }
}

