/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.CloudException;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.UriBasedServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.util.UriInfo;

@ServiceInfo.ServiceLabel(value="rabbitmq")
public class AmqpServiceInfo
extends UriBasedServiceInfo {
    private static final Integer DEFAULT_AMQP_PORT = 5672;
    private static final Integer DEFAULT_AMQPS_PORT = 5671;
    public static final String AMQP_SCHEME = "amqp";
    public static final String AMQPS_SCHEME = "amqps";
    private String managementUri;
    private List<String> uris;
    private List<String> managementUris;
    private String virtualHost;

    public AmqpServiceInfo(String id, String host, int port, String username, String password, String virtualHost) {
        this(id, host, port, username, password, virtualHost, null);
    }

    public AmqpServiceInfo(String id, String host, int port, String username, String password, String virtualHost, String managementUri) {
        super(id, AMQP_SCHEME, host, port, username, password, virtualHost);
        this.managementUri = managementUri;
        this.virtualHost = this.decode(this.getUriInfo().getPath());
    }

    public AmqpServiceInfo(String id, String uri, String managementUri, List<String> uris, List<String> managementUris) {
        this(id, uri, managementUri);
        this.uris = uris;
        this.managementUris = managementUris;
    }

    public AmqpServiceInfo(String id, String uri) throws CloudException {
        this(id, uri, null);
    }

    public AmqpServiceInfo(String id, String uri, String managementUri) throws CloudException {
        super(id, uri);
        this.managementUri = managementUri;
        this.virtualHost = this.decode(this.getUriInfo().getPath());
    }

    private String decode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getVirtualHost() {
        return this.virtualHost;
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getManagementUri() {
        return this.managementUri;
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public List<String> getUris() {
        return this.uris;
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public List<String> getManagementUris() {
        return this.managementUris;
    }

    @Override
    @ServiceInfo.ServiceProperty(category="connection")
    public int getPort() {
        if (super.getPort() == -1) {
            if (this.getScheme().equals(AMQP_SCHEME)) {
                return DEFAULT_AMQP_PORT;
            }
            if (this.getScheme().equals(AMQPS_SCHEME)) {
                return DEFAULT_AMQPS_PORT;
            }
        }
        return super.getPort();
    }

    @Override
    protected UriInfo validateAndCleanUriInfo(UriInfo uriInfo) {
        if (uriInfo.getScheme() == null) {
            throw new IllegalArgumentException("Missing scheme in amqp URI: " + uriInfo);
        }
        if (uriInfo.getHost() == null) {
            throw new IllegalArgumentException("Missing authority in amqp URI: " + uriInfo);
        }
        if (uriInfo.getUserName() == null || uriInfo.getPassword() == null) {
            throw new IllegalArgumentException("Missing userinfo in amqp URI: " + uriInfo);
        }
        String path = uriInfo.getPath();
        if (path != null && path.indexOf(47) != -1) {
            throw new IllegalArgumentException("Multiple segments in path of amqp URI: " + uriInfo);
        }
        return uriInfo;
    }
}

