/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.common;

import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.UriBasedServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.util.UriInfo;

public abstract class RelationalServiceInfo
extends UriBasedServiceInfo {
    public static final String JDBC_PREFIX = "jdbc:";
    protected final String jdbcUrl;
    protected final String jdbcUrlDatabaseType;

    public RelationalServiceInfo(String id, String uriString, String jdbcUrlDatabaseType) {
        this(id, uriString, null, jdbcUrlDatabaseType);
    }

    public RelationalServiceInfo(String id, String uriString, String jdbcUrl, String jdbcUrlDatabaseType) {
        super(id, uriString);
        this.jdbcUrl = jdbcUrl;
        this.jdbcUrlDatabaseType = jdbcUrlDatabaseType;
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getJdbcUrl() {
        return this.jdbcUrl == null ? this.buildJdbcUrl() : this.jdbcUrl;
    }

    protected String buildJdbcUrl() {
        return String.format("%s%s://%s%s/%s%s%s", JDBC_PREFIX, this.jdbcUrlDatabaseType, this.getHost(), this.formatPort(), this.getPath(), this.formatUserinfo(), this.formatQuery());
    }

    private String formatPort() {
        if (this.getPort() != -1) {
            return String.format(":%d", this.getPort());
        }
        return "";
    }

    private String formatUserinfo() {
        if (this.getUserName() != null && this.getPassword() != null) {
            return String.format("?user=%s&password=%s", UriInfo.urlEncode(this.getUserName()), UriInfo.urlEncode(this.getPassword()));
        }
        if (this.getUserName() != null) {
            return String.format("?user=%s", UriInfo.urlEncode(this.getUserName()));
        }
        return "";
    }

    private String formatQuery() {
        if (this.getQuery() != null) {
            if (this.formatUserinfo().isEmpty()) {
                return String.format("?%s", this.getQuery());
            }
            return String.format("&%s", this.getQuery());
        }
        return "";
    }
}

