/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.document;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorCreationException;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.common.MongoServiceInfo;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.document.MongoDbFactoryConfig;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

public class MongoDbFactoryCreator
extends AbstractServiceConnectorCreator<MongoDbFactory, MongoServiceInfo> {
    @Override
    public MongoDbFactory create(MongoServiceInfo serviceInfo, ServiceConnectorConfig config) {
        try {
            MongoClientOptions.Builder mongoOptionsToUse = this.getMongoOptions((MongoDbFactoryConfig)config);
            SimpleMongoDbFactory mongoDbFactory = this.createMongoDbFactory(serviceInfo, mongoOptionsToUse);
            return this.configure(mongoDbFactory, (MongoDbFactoryConfig)config);
        }
        catch (UnknownHostException e) {
            throw new ServiceConnectorCreationException(e);
        }
        catch (MongoException e) {
            throw new ServiceConnectorCreationException(e);
        }
    }

    private SimpleMongoDbFactory createMongoDbFactory(MongoServiceInfo serviceInfo, MongoClientOptions.Builder mongoOptionsToUse) throws UnknownHostException {
        MongoClientURI mongoClientURI = new MongoClientURI(serviceInfo.getUri(), mongoOptionsToUse);
        MongoClient mongo = new MongoClient(mongoClientURI);
        return new SimpleMongoDbFactory(mongo, mongoClientURI.getDatabase());
    }

    private MongoClientOptions.Builder getMongoOptions(MongoDbFactoryConfig config) {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        if (config != null) {
            if (config.getConnectionsPerHost() != null) {
                builder.connectionsPerHost(config.getConnectionsPerHost().intValue());
            }
            if (config.getMaxWaitTime() != null) {
                builder.maxWaitTime(config.getMaxWaitTime().intValue());
            }
            if (config.getWriteConcern() != null) {
                builder.writeConcern(new WriteConcern(config.getWriteConcern()));
            }
        }
        return builder;
    }

    public SimpleMongoDbFactory configure(SimpleMongoDbFactory mongoDbFactory, MongoDbFactoryConfig config) {
        WriteConcern writeConcern;
        if (config != null && config.getWriteConcern() != null && (writeConcern = WriteConcern.valueOf((String)config.getWriteConcern())) != null) {
            mongoDbFactory.setWriteConcern(writeConcern);
        }
        return mongoDbFactory;
    }
}

