/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reconfiguration.org.springframework.cloud.service.keyval;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.MapServiceConnectionConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.MapServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.ServiceConnectorConfigurer;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.Util;
import org.cloudfoundry.reconfiguration.org.springframework.cloud.service.keyval.RedisConnectionFactoryConfig;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import redis.clients.jedis.JedisPoolConfig;

public class RedisJedisClientConfigurer
implements ServiceConnectorConfigurer<JedisClientConfiguration.JedisClientConfigurationBuilder, RedisConnectionFactoryConfig> {
    private MapServiceConnectionConfigurer<JedisClientConfiguration.JedisClientConfigurationBuilder, MapServiceConnectorConfig> mapClientConfigurer = new MapServiceConnectionConfigurer();

    @Override
    public JedisClientConfiguration.JedisClientConfigurationBuilder configure(JedisClientConfiguration.JedisClientConfigurationBuilder clientConfiguration, RedisConnectionFactoryConfig config) {
        if (config != null) {
            this.configurePool(clientConfiguration, config);
            this.configureClient(clientConfiguration, config);
        }
        return clientConfiguration;
    }

    @Override
    public JedisClientConfiguration.JedisClientConfigurationBuilder configure(JedisClientConfiguration.JedisClientConfigurationBuilder clientConfiguration, PooledServiceConnectorConfig config) {
        if (config != null) {
            this.configurePool(clientConfiguration, config);
        }
        return clientConfiguration;
    }

    private void configurePool(JedisClientConfiguration.JedisClientConfigurationBuilder clientConfiguration, PooledServiceConnectorConfig config) {
        if (config.getPoolConfig() != null) {
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            BeanWrapperImpl target = new BeanWrapperImpl((Object)poolConfig);
            BeanWrapperImpl source = new BeanWrapperImpl((Object)config.getPoolConfig());
            Util.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)source);
            clientConfiguration.usePooling().poolConfig((GenericObjectPoolConfig)poolConfig);
        }
    }

    private void configureClient(JedisClientConfiguration.JedisClientConfigurationBuilder clientConfiguration, RedisConnectionFactoryConfig config) {
        if (config.getConnectionProperties() != null) {
            this.mapClientConfigurer.configure(clientConfiguration, config.getConnectionProperties());
        }
    }
}

